from django.contrib import admin
from django.urls import path, include
from api.views import doc_login
from api.admin_views import all_users
from rest_framework.schemas import get_schema_view

from rest_framework import permissions
from drf_yasg.views import get_schema_view
from drf_yasg import openapi

from django.conf import settings
from django.conf.urls.static import static

from django.contrib.auth.decorators import login_required


admin.site.site_header = 'Nubyira Admin'
admin.site.site_title = 'Nubyira Admin Portal'
admin.site.index_title = "Welcome to Nubyira admin portal"


schema_view = get_schema_view(
    openapi.Info(
        title="Nubyira API",
        default_version='v1',
        description='API support for nubyira frontend pages',
        contact=openapi.Contact(email="admin@nubyira.com"),
        license=openapi.License(name="BSD License"),
    ),
    public=True,
    permission_classes=(permissions.AllowAny,),
)


handler404 = 'api.views.view_404'
handler500 = 'api.views.view_500'


urlpatterns = [
    path('admin/', admin.site.urls),
    path('ckeditor/', include('ckeditor_uploader.urls')),
    path('api/v1/', include('api.urls')),
    # API DOCs
    path('swagger/',
        schema_view.without_ui(cache_timeout=0), name='schema-without-ui'),
    path('docs/', login_required(schema_view.with_ui('swagger',
        cache_timeout=0)), name='schema-swagger-ui'),
    path('redoc/', schema_view.with_ui('redoc',
        cache_timeout=0), name='schema-redoc'),
    path("accounts/login/", doc_login, name='doc_login'),
    path("", all_users, name="admin_page")
]



urlpatterns += static(settings.STATIC_URL,
                          document_root=settings.STATIC_ROOT)
urlpatterns += static(settings.MEDIA_URL,
                          document_root=settings.MEDIA_ROOT)
