from pathlib import Path
import os
from datetime import timedelta

# from decouple import config
# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent
from django.core.management.utils import get_random_secret_key

# from secret import SECRET_KEY

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/3.2/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = os.environ.get("SECRET_KEY", default=get_random_secret_key())
# SECURITY WARNING: don't run with debug turned on in production!

DEBUG = False

from dotenv import load_dotenv
load_dotenv()
    

# ALLOWED_HOSTS = ["api.nubyira.com"]
ALLOWED_HOSTS = ["*"]

CORS_ORIGIN_ALLOW_ALL = True  # To be changed when going live


# To be used for final production

# CORS_ORIGIN_WHITELIST = (
#       'https://nubyira.com',
#       'https://www.nubyira.com',
# )



CSRF_TRUSTED_ORIGINS = ['https://nubyira.com', 'https://www.nubyira.com']

UPDATE_LAST_LOGIN = True


# Application definition
#
INSTALLED_APPS = [
    'jazzmin',
    "django.contrib.admin",
    "django.contrib.auth",
    "django.contrib.contenttypes",
    "django.contrib.sessions",
    "django.contrib.messages",
    'django.contrib.humanize',
    "django.contrib.staticfiles",
    "api",
    "corsheaders",
    "rest_framework",
    "rest_framework.authtoken",
    "ckeditor_uploader",
    "ckeditor",
    "taggit",
    "drf_yasg",
]

# IP_GEOLOCATION_SETTINGS = {
#     'BACKEND': 'django_ip_geolocation.backends.IPGeolocationAPI',
#     'BACKEND_API_KEY': '',
#     'BACKEND_EXTRA_PARAMS': {},
#     'BACKEND_USERNAME': '',
#     'RESPONSE_HEADER': 'X-IP-Geolocation',
#     'ENABLE_REQUEST_HOOK': True,
#     'ENABLE_RESPONSE_HOOK': True,
#     'ENABLE_COOKIE': False,
#     'FORCE_IP_ADDR': None,
#     'USER_CONSENT_VALIDATOR': None
# }
# IPRESTRICT_GEOIP_ENABLED = False

MIDDLEWARE = [
    "django.middleware.security.SecurityMiddleware",
    "django_country2.middleware.CountryMiddleware",
    # 'django_ip_geolocation.middleware.IpGeolocationMiddleware',
    "django.contrib.sessions.middleware.SessionMiddleware",
    "corsheaders.middleware.CorsMiddleware",
    "whitenoise.middleware.WhiteNoiseMiddleware",
    "django.middleware.common.CommonMiddleware",
    "django.middleware.csrf.CsrfViewMiddleware",
    "django.contrib.auth.middleware.AuthenticationMiddleware",
    "django.contrib.messages.middleware.MessageMiddleware",
    "django.middleware.clickjacking.XFrameOptionsMiddleware",
]
# X_FRAME_OPTIONS = 'SAMEORIGIN'
# X_FRAME_OPTIONS = 'ALLOW-FROM https://api.paystack.co/decision/ip'
COUNTRY_CODE = "NG"
ROOT_URLCONF = "nubyira.urls"

TEMPLATES = [
    {
        "BACKEND": "django.template.backends.django.DjangoTemplates",
        "DIRS": [BASE_DIR / "templates"],
        "APP_DIRS": True,
        "OPTIONS": {
            "context_processors": [
                "django.template.context_processors.debug",
                "django.template.context_processors.request",
                "django.contrib.auth.context_processors.auth",
                "django.contrib.messages.context_processors.messages",
            ],
        },
    },
]

WSGI_APPLICATION = "nubyira.wsgi.application"


# Database
# https://docs.djangoproject.com/en/3.2/ref/settings/#databases
DATABASES = {
    "default": {
        #"ENGINE": "django.db.backends.sqlite3",
        #"NAME": BASE_DIR / "db.sqlite3",
        # # The engine to use for creating the database.
        #'ENGINE': 'django.db.backends.postgresql_psycopg2',
        'ENGINE': 'django.db.backends.mysql',
        # # Name of the database to use
        'NAME': os.getenv("db_name"),
        # # Username to connect to the database credentials
        'USER': os.getenv("db_user"),
        'PASSWORD': os.getenv("db_pass"),
        # # Host to connect to the database
        'HOST': os.getenv("db_host"),
        # # Port to connect to the database
        'PORT': "3306",
        'OPTIONS': {
            'init_command': "SET sql_mode='STRICT_TRANS_TABLES'"
            }
    }
}



# DATABASES = {
#     'default': {
#         'ENGINE': 'django.db.backends.sqlite3',
#         'NAME': BASE_DIR / 'db.sqlite3',  # Creates database file in project root
#     }
# }
# db_from_env = dj_database_url.config(conn_max_age=500)
# DATABASES["default"].update(db_from_env)


# Password validation
# https://docs.djangoproject.com/en/3.2/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        "NAME": "django.contrib.auth.password_validation.UserAttributeSimilarityValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.MinimumLengthValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.CommonPasswordValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.NumericPasswordValidator",
    },
]


# Internationalization
# https://docs.djangoproject.com/en/3.2/topics/i18n/

LANGUAGE_CODE = "en-us"

TIME_ZONE = "Africa/Lagos"

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/3.2/howto/static-files/

STATIC_URL = "/static/"
STATIC_ROOT = '/home/gdtyouqx/api.nubyira.com/staticfiles/'
STATICFILES_DIRS = [BASE_DIR / "static"]
#STATICFILES_DIRS = '/home/gdtyouqx/api.nubyira.com/static/'

MEDIA_URL = "/media/"
MEDIA_ROOT = '/home/gdtyouqx/api.nubyira.com/static/media/'

# STATICFILES_STORAGE = "whitenoise.storage.CompressedManifestStaticFilesStorage"

# STATIC_ROOT = BASE_DIR / "static/"

# Default primary key field type
# https://docs.djangoproject.com/en/3.2/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = "django.db.models.BigAutoField"


AUTH_USER_MODEL = "api.User"


REST_FRAMEWORK = {
    "DEFAULT_AUTHENTICATION_CLASSES": (
        # 'rest_framework.authentication.TokenAuthentication',
        "api.authentication.ExpiringTokenAuthentication",  # custom authentication class
        # 'rest_framework_simplejwt.authentication.JWTAuthentication',
    ),
    "DEFAULT_PERMISSION_CLASSES": (
        # This ensure that for any views to be viewed the user is expected to supplied auth token key in the header as authorization
        "rest_framework.permissions.AllowAny",
    ),
    "DEFAULT_PAGINATION_CLASS": "rest_framework.pagination.PageNumberPagination",
    "PAGE_SIZE": 3,
    "DATE_FORMAT": "%d/%m/%Y",
}

TOKEN_EXPIRED_AFTER_SECONDS = 86400  # 24 hour validity for token on production


EMAIL_USE_TLS = True
EMAIL_HOST = os.environ.get("EMAIL_HOST")
EMAIL_BACKEND = 'api.backend.email.EmailBackend'
EMAIL_HOST_USER = os.environ.get("EMAIL_HOST_USER")
EMAIL_HOST_PASSWORD = os.environ.get("EMAIL_HOST_PASSWORD")
EMAIL_PORT = os.environ.get("EMAIL_PORT")
EMAIL_USE_SSL = False

ZEPTO_MAIL_TOKEN = os.getenv("ZEPTO_MAIL_TOKEN")
ZOHO_DEFAULT_FROM_EMAIL = "noreply@nubyira.com"

DEFAULT_FROM_MAIL = os.environ.get("EMAIL_HOST_USER")


# CLOUDINARY_STORAGE = {
#     "CLOUD_NAME": os.environ.get("CLOUD_NAME"),
#     "API_KEY": os.environ.get("API_KEY"),
#     "API_SECRET": os.environ.get("API_SECRET"),
# }

# DEFAULT_FILE_STORAGE = "cloudinary_storage.storage.MediaCloudinaryStorage"


# CKEditor Settings
CKEDITOR_UPLOAD_PATH = "uploads/"
CKEDITOR_IMAGE_BACKEND = "pillow"

CKEDITOR_CONFIGS = {
    "default": {
        "toolbar": "full",
        "width": "auto",
        "extraPlugins": ",".join(["youtube"]),
    },
}


SWAGGER_SETTINGS = {
    "SECURITY_DEFINITIONS": {
        "api_key": {"type": "apiKey", "name": "Token Key", "in": "header"},
    },
}


# CACHES = {
#     'default': {
#         'BACKEND': 'django_redis.cache.RedisCache',
#         'LOCATION': os.environ.get("REDIS_URL", 'redis://127.0.0.1:6379/1'),
#         'OPTIONS': {
#             'CLIENT_CLASS': 'django_redis.client.DefaultClient',
#         }
#     }
#     }


# SIMPLE_JWT = {
#     'ACCESS_TOKEN_LIFETIME': timedelta(minutes=5),
#     'REFRESH_TOKEN_LIFETIME': timedelta(days=1),
#     'ROTATE_REFRESH_TOKENS': False,
#     'BLACKLIST_AFTER_ROTATION': True,
#     'UPDATE_LAST_LOGIN': False,

#     'ALGORITHM': 'HS256',
#     'SIGNING_KEY': settings.SECRET_KEY,
#     'VERIFYING_KEY': None,
#     'AUDIENCE': None,
#     'ISSUER': None,
#     'JWK_URL': None,
#     'LEEWAY': 0,

#     'AUTH_HEADER_TYPES': ('Bearer',),
#     'AUTH_HEADER_NAME': 'HTTP_AUTHORIZATION',
#     'USER_ID_FIELD': 'id',
#     'USER_ID_CLAIM': 'user_id',
#     'USER_AUTHENTICATION_RULE': 'rest_framework_simplejwt.authentication.default_user_authentication_rule',

#     'AUTH_TOKEN_CLASSES': ('rest_framework_simplejwt.tokens.AccessToken',),
#     'TOKEN_TYPE_CLAIM': 'token_type',

#     'JTI_CLAIM': 'jti',

#     'SLIDING_TOKEN_REFRESH_EXP_CLAIM': 'refresh_exp',
#     'SLIDING_TOKEN_LIFETIME': timedelta(minutes=5),
#     'SLIDING_TOKEN_REFRESH_LIFETIME': timedelta(days=1),
# }

# LOGIN_URL = 'doc_login/'

# "api.review","api.project_batch", "api.comment","api.saved_blogs","api.course_certificate","api.course_prerequesites", "api.objectives", "api.course_audience", "api.Ads", "api.extra_participant",
JAZZMIN_SETTINGS = {
    "changeform_format_overrides": {"auth.user": "collapsible", "auth.group": "vertical_tabs"},
    # Hide these models when generating side menu (e.g auth.user)
    "hide_models": ["api.course_registered_user_proxy",
                     "api.paypal_access", "api.IpModel",
                     "api.passwordresetcode", "api.emailconfirmationcode",
                     ],
    # Links to put along the top menu
    "topmenu_links": [

        # Url that gets reversed (Permissions can be added)
        {"name": "Home",  "url": "admin:index"},


        # model admin to link to (Permissions checked against model)
        {"model": "api.Courses"},
        {"model": "api.User"},
        {"model": "api.course_registred_user"},
        {"model":"api.Subscription"}
    ],
    "hide_apps": ["taggit", "auth", "authtoken"],
    "icons": {
        "api": "fas fa-users-cog",
        "api.user": "fas fa-user",
        "api.Courses": "fas fa-book",
        "api.Group": "fas fa-users",
    },

    "usermenu_links": [
        {"name": "Bachend Github",
            "url": "https://github.com/Ajibson", "new_window": True},
        {"model": "api.User"}
    ],
    # "show_ui_builder": True,
    "related_modal_active": True,
    "site_logo": "static/assets/img/elements/cc2c.jpg",

}


JAZZMIN_UI_TWEAKS = {
    "navbar_small_text": False,
    "footer_small_text": False,
    "body_small_text": False,
    "brand_small_text": False,
    "brand_colour": False,
    "accent": "accent-primary",
    "navbar": "navbar-dark",
    "no_navbar_border": False,
    "navbar_fixed": False,
    "layout_boxed": False,
    "footer_fixed": False,
    "sidebar_fixed": False,
    "sidebar": "sidebar-dark-secondary",
    "sidebar_nav_small_text": False,
    "sidebar_disable_expand": False,
    "sidebar_nav_child_indent": False,
    "sidebar_nav_compact_style": False,
    "sidebar_nav_legacy_style": False,
    "sidebar_nav_flat_style": False,
    "theme": "default",
    "dark_mode_theme": None,
    "button_classes": {
        "primary": "btn-outline-info",
        "secondary": "btn-outline-secondary",
        "info": "btn-outline-info",
        "warning": "btn-outline-warning",
        "danger": "btn-outline-danger",
        "success": "btn-outline-success"
    }
}
