from datetime import timedelta
from django.http import FileResponse
from .swagger_doc import *
import wget
from django.views.decorators.cache import cache_page
from django.shortcuts import redirect, render
from .models import *
from .course_models import *
from .serializer import *
from .payment import (
    deposit,
    run_work,
    subscribed,
    get_access_token,
)
from .course_cid import course_cid
from .next_prev import prev_next
from django.core.paginator import Paginator, EmptyPage
from rest_framework.response import Response
from rest_framework import status
from rest_framework.decorators import api_view, permission_classes, parser_classes
from rest_framework.permissions import IsAuthenticated, AllowAny
from rest_framework.authtoken.models import Token
from django.utils import timezone
from .authentication import token_expire_handler, expires_in
from django.contrib.auth import authenticate, login, logout
from rest_framework.parsers import MultiPartParser, FormParser
from django.utils.encoding import force_str
from django.utils.http import urlsafe_base64_decode
from django.http import HttpResponse
from urllib.parse import urlencode
from urllib.request import urlopen
from .course_cid import course_cid, generate_cid
import json
from django.db.models import Q
import os
import requests
import uuid
from django import template
from .email import *
from .scripts import (
    save_other_participants,
    password_validator,
    paginate,
    single_web_response,
)
from django.core.cache import cache
register = template.Library()
# from django_ip_geolocation.decorators import with_ip_geolocation
# from django.contrib.gis.utils.geoip import GeoIP

# @ api_view(["POST", "GET"])
# @with_ip_geolocation
# def loc_req(request):
#     # print(request)
#     # g = GeoIP()
#     ip = request.META.get('REMOTE_ADDR', None)
#     # if (not ip or ip == '127.0.0.1'):
#     #     ip = request.META['HTTP_X_FORWARDED_FOR']
#     # if ip:
        
#     # else:
#     #     city = "Jigawa"
#     return Response({"loc":ip})

# Registration View
@ register_post_doc()
@ api_view(["POST"])  # Only post request will be accpted
def register(request):
    """This get user registered in the system"""
    # confirm if the method that entered is truly POST request
    if request.method == "POST":
        serializer = RegistrationSerializer(data=request.data)
        user_status = request.data.get("user")

        data = {}

        if serializer.is_valid():
            account = serializer.save()
            # Send confirmation email
            email_result = account_confirmation(account, user_status)
            data[
                "response"
            ] = "Registration Successfully, Please check your email for confirmation"
            return Response(data, status=status.HTTP_201_CREATED)

        else:
            return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)


# Account confirmation
@ api_view(["GET"])
def activate_mail(request, uidb64, token, user_status=None):
    login_url = "https://nubyira.com/pages/login.html"
    query_string = urlencode(
        {"link_status": "expired", "link_code": "verification"})
    try:
        uid = force_str(urlsafe_base64_decode(uidb64))
        user = User.objects.get(id=uid)
        if user:
            # get the token object
            token = emailconfirmationcode.objects.get(user=user)
            time_diff = timezone.now() - token.created_at
            if time_diff.total_seconds() > 420:  # 7 minutes duration check
                token.delete()
                if user_status:
                    query_string = urlencode(
                        {
                            "link_status": "expired",
                            "link_code": "verification",
                            "user": user_status,
                        }
                    )
                url = f"{login_url}?{query_string}"
                return redirect(url)
            else:
                token.delete()
                user.is_verified = True
                user.save()
                if user_status == "None":
                    query_string = urlencode(
                        {"link_status": "signup", "link_code": "verification"}
                    )
                else:
                    query_string = urlencode(
                        {"link_status": "enroll", "link_code": "verification"}
                    )
                url = f"{login_url}?{query_string}"
                return redirect(url)
    except User.DoesNotExist:
        return redirect("https://nubyira.com/pages/login.html")
    except emailconfirmationcode.DoesNotExist:
        # request for page to tell user to get reset link
        url = f"{login_url}?{query_string}"
        return redirect(url)


# Resend verification link
@resend_conf_email_doc()
@api_view(["POST"])
def resend_activation_link(request):
    login_url = "https://nubyira.com/pages/login.html"
    try:
        email = request.data["email"]
        user_status = request.data.get("user", "verification")

        account = User.objects.get(email=email, is_verified=False)
        email_result = account_confirmation(account, user_status)
        if email_result:
            return Response(
                {"response": "If user is registered an email has been sent."},
                status=status.HTTP_200_OK,
            )
        else:
            # resend email
            email_result = account_confirmation(account, user_status)
            if email_result:
                return Response(
                    {"response": "If user is registered an email has been sent."}
                )
            else:
                query_string = urlencode(
                    {"link_status": "expired", "link_code": "verification"}
                )
                url = f"{login_url}?{query_string}"
                return redirect(url)
    except (User.DoesNotExist, KeyError):
        return Response(
            {"response": "If user is registered an email has been sent."},
            status=status.HTTP_400_BAD_REQUEST,
        )


# Login View
@login_post_doc()
@api_view(["POST"])
def Loginview(request):
    """This view authenticate the user and thus redirect the user to the homepage or dashboard as it may be"""
    serializer = LoginSerializer(data=request.data)
    if serializer.is_valid():
        email = serializer.data["email"]
        password = serializer.data["password"]
        user = authenticate(request, email=email, password=password)
        # Cheack if there is a user is returned
        if user:
            if user.is_verified:
                # Get the token key for the user in the database or create one if not there
                token, created = Token.objects.get_or_create(user=user)
                # This will ensure a new token is given, if the one there has expired and the user did not logout before loggin in again
                # status is passed to differecntiate from the authenticate endpoint
                is_expired, token = token_expire_handler(token, status="login")

                # Update user last login timestamp
                user.last_login = timezone.now()
                user.save()
                return Response(
                    {"success": {"first_name": user.first_name, "token": token.key}},
                    status=status.HTTP_200_OK,
                )
            else:
                response = {
                    "Error": "Email not confirmed or user is not registered"}
                return Response(response, status=status.HTTP_401_UNAUTHORIZED)
        else:
            response = {"Error": "Unable to login with provided credentials."}
            return Response(response, status=status.HTTP_401_UNAUTHORIZED)
    else:
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)


@authenticate_doc()
@api_view(["POST"])
@permission_classes((IsAuthenticated,))
def authenticate_user(request):
    if request.method == "POST":
        user = request.user
        token, created = Token.objects.get_or_create(user=user)
        if not created:
            is_expired, token = token_expire_handler(token)
        if is_expired:
            validity = "invalid"
        else:
            validity = "valid"
        data = {"user_name": user.first_name, "validity": validity}
        pid = request.data.get("pid", "home")
        data["pid"] = pid

        try:
            avatar = request.user.image.url
            data["avatar"] = avatar
        except (KeyError, ValueError):
            pass

        return Response({"response": data}, status=status.HTTP_200_OK)


# logout view
@logout_post_doc()
@api_view(["POST"])
@permission_classes((IsAuthenticated,))
def logout_user(request):
    """Remove all the token owned by the user \n This only takes user's token key as header authorization"""
    tokens = Token.objects.filter(user=request.user)
    tokens.delete()
    response = {"success": "User logged out successfully"}
    return Response(response, status=status.HTTP_200_OK)


def Logout(request):
    logout(request)
    return redirect("https://nubyira.com")


@reset_password_doc()
@api_view(["POST"])
def reset_password(request):

    if request.method == "POST":
        # check if a user exist with the email
        try:
            recieved_email = request.data["email"]
            user = User.objects.get(email=recieved_email)
            send_email = password_reset_email(user)
            return Response(
                {"Success": "Reset link has been sent successfully"},
                status=status.HTTP_200_OK,
            )
        except User.DoesNotExist:
            return Response(
                {"response": "Email not registered"}, status=status.HTTP_400_BAD_REQUEST
            )
        except KeyError:
            return Response(
                {"response": "email field is missing"},
                status=status.HTTP_400_BAD_REQUEST,
            )


# Password reset link confirmation endpoint
@api_view(["GET"])
def password_reset_link_confirmation(request, uidb64, token):
    login_url = "https://nubyira.com/pages/login.html"
    query_string = urlencode(
        {"link_status": "expired", "link_code": "reset_password"})
    try:
        uid = force_str(urlsafe_base64_decode(uidb64))
        user = User.objects.get(id=uid)
        get_token = passwordresetcode.objects.get(code=token)
        date = timezone.now() - get_token.created_at
        if user and get_token:
            if date.total_seconds() > 420:  # 7 min set for link expiration
                get_token.delete()
                # the return should be the page to request for another reset link
                url = "{}?{}".format(login_url, query_string)
                return redirect(url)
            else:
                get_token.checked = True
                get_token.save()
                query_string = urlencode({"email": user.email})
                url = "{}?{}".format(login_url, query_string)
                # redirect to the page to input new password
                return redirect(url)
    except (User.DoesNotExist, passwordresetcode.DoesNotExist):
        # then return should be the page to request for another reset link
        url = "{}?{}".format(login_url, query_string)
        return redirect(url)


# Reset password View
@password_reset_confirm_doc()
@api_view(["POST"])
def password_reset_confirm(request):
    # This get this user's new password saved
    login_url = "https://nubyira.com/pages/login.html"
    query_string = urlencode(
        {"link_status": "expired", "link_code": "reset_password"})
    if request.method == "POST":
        try:
            serializer = PasswordResetSerializer(data=request.data)
            if serializer.is_valid():
                user = User.objects.get(email=request.data["email"])
                get_token = passwordresetcode.objects.get(user=user)
                if get_token.checked:
                    get_token.delete()
                    new_password = serializer.data["new_password"]
                    confirm_new_password = serializer.data["confirm_new_password"]
                    return password_validator(user, new_password, confirm_new_password)
                else:
                    return Response(
                        {"response": "Who are you ): "},
                        status=status.HTTP_400_BAD_REQUEST,
                    )
            else:
                return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)
        except (User.DoesNotExist, passwordresetcode.DoesNotExist):
            return redirect("{}?{}".format(login_url, query_string))
            # Redirect user to the page to get reset link again
        except KeyError:
            return Response(
                {"response": "user not known or email not provided"},
                status=status.HTTP_400_BAD_REQUEST,
            )


# Course view list
@api_view(["GET"])
def course_view(request):
    # Get the list of courses in the database
    if request.method == "GET":
        course_list = (
            Courses.objects.filter(course_tab="Webinar")
            .order_by("category", "title")
        )
        serializer = courseSerializer(course_list, many=True)
        data = {"pid": "learn", "courses": serializer.data}
        return Response(data, status=status.HTTP_200_OK)


def get_cached_courses(course_tab):
    # get the cached version
    # courses = cache.get(f"{course_tab.capitalize()}Courses")
    courses = None
    if not courses:
        courses = Courses.objects.filter(
            course_tab=course_tab.capitalize()).order_by("-last_updated", "category", "title")
        # cache.set(f"{course_tab.capitalize()}Courses", courses)
    return courses

@api_view(["GET"])
def sort_filter(request):
    filters = Filter.objects.filter(on=True)
    sorts = Sort.objects.filter(on = True)
    filtercategory = FilterCategory.objects.all()
    filter_serializers = FilterSerializer(filtercategory, many = True)
    sort_serializer = SortSerializer(sorts, many=True)

    response = {
        "filters":filter_serializers.data, "sorts":sort_serializer.data
    }

    return Response(response)


def filter_sort_course(sort_params=None, filter_params=None, course=None):
    # sort_params = sort_params.split(":")[1]
    
    query = Q()
    if filter_params:
        cat_list, soft_list, field_list = [], [], []
        for filter_obj in filter_params:
            # filter_split = filter_obj.split(":")[0].lower()
            # get the category from the filter table
            filt_cat = Filter.objects.filter(label__icontains=filter_obj).first()
            
            if filt_cat.category.name == "Training Software":
                # soft_filter = filter_obj.split(":")[1].replace("-"," ")
                soft_list.append(filter_obj)
                query |= Q(training_software__icontains=filter_obj)
            if filt_cat.category.name == "Course Category":
                # cat_filter = filter_obj.split(":")[1].capitalize()
                cat_list.append(filt_cat)
                query |= Q(category__icontains = filter_obj)
            if filt_cat.category.name == 'Course Field':
                # field_filter = filter_obj.split(":")[1].replace("-", " ")
                query |= Q(field = filt_cat)
        # soft_ex_list = list(set([course.training_software for course in Courses.objects.filter(course_tab="Webinar") if course.training_software not in soft_list]))
        # cat_ex_list = list(set([course.category for course in Courses.objects.filter(course_tab="Webinar") if course.category not in cat_list]))
    courses = course.filter(query)
    if sort_params == "asc":
        courses = courses.order_by("title")
    elif sort_params == "dsc":
        courses = courses.order_by("-title")
    elif sort_params == "newest-first":
        courses = courses.order_by("-date_created","-last_updated")
    elif sort_params == "oldest-first":
        courses = courses.order_by("-date_created","-last_updated")
        # .exclude(training_software__in = soft_ex_list).exclude(category__in = cat_ex_list)
    return courses



@allCourseList_doc()
@api_view(["POST", "GET"])
def allCoursesList(request):
    page_number = request.data.get("page", 1)
    course_tab = request.data.get("course_tab")
    sort_params = request.GET.get("sort") 
    filter_params = request.GET.getlist('filter')
    response = {}
    if course_tab:
        # TODO: cache implementation
        courses = get_cached_courses(course_tab)
       
        if sort_params and filter_params:
            courses = filter_sort_course(sort_params=sort_params, filter_params=filter_params, course=courses)
        elif sort_params:
            courses = filter_sort_course(sort_params=sort_params, course=courses)
        elif filter_params:
            courses = filter_sort_course(filter_params=filter_params, course=courses)
        if not courses:
            return Response({"response": "No courses available for the tab selected"})
        # paginate the result
        if course_tab.lower() == "webinar":
            response.update(paginate(courses, page_number, courseSerializer))
        elif course_tab.lower() == "free" or course_tab.lower() == "premium":
            response.update(
                paginate(courses, page_number, courseListSerializer))

    else:
        sort_map = {}
        courses = Courses.objects.all()
        if sort_params and filter_params:
            courses = filter_sort_course(sort_params=sort_params, filter_params=filter_params,course=courses)
        elif sort_params:
            courses = filter_sort_course(sort_params=sort_params,course=courses)
        elif filter_params:
            courses = filter_sort_course(filter_params=filter_params,course=courses )
        # courses = cache.get("allCoursesList")
        else:
            courses = Courses.objects.order_by(
                "-last_updated", "category", "title")
            cache.set("allCoursesList", courses)

        response.update(
            {
                "Webinar": paginate(
                    courses.filter(
                        course_tab="Webinar"), page_number, courseSerializer
                ),
                "Free": paginate(
                    courses.filter(
                        course_tab="Free"), page_number, courseListSerializer
                ),
                "Premium": paginate(
                    courses.filter(course_tab="Premium"),
                    page_number,
                    courseListSerializer,
                ),
            }
        )

    return Response(response)


@api_view(["GET"])
def generate_cid_view(request):
    courses = Courses.objects.all()
    for course in courses:
        course.cid = uuid.uuid4().hex
        course.save()

    return Response({"success": "Courses cid updated"})


@course_info_doc()
@api_view(['POST'])
@permission_classes((AllowAny,))
def course_info(request):
    if request.method == "POST":
        cid = request.data['cid']
        # TODO cache implemetation
        course = Courses.objects.filter(cid=cid).first()
        batch_details = course_batch.objects.filter(
            course=course).first()
        # next_batch_date = batch_details.next_batch_date.strftime("%d/%m/%Y")
        next_batch_time = batch_details.next_batch_time
        next_batch_date = course.reg_end_date.date().strftime("%d/%m/%Y")
        serializer = courseinfoeSerializer(course)

        data = {"pid": "reg",
                "next_batch_date": next_batch_date, "next_batch_time": next_batch_time}
        data.update(serializer.data)
        return Response(data, status=status.HTTP_200_OK)


@single_course_doc()
@api_view(["POST"])
def get_course(request):

    if request.method == "POST":
        try:
            cid = request.data["cid"].strip()
            course_gotten = Courses.objects.get(cid=cid)
            prev_course, next_course = prev_next(course_gotten, "course")
            if course_gotten.course_tab == "Webinar":
                response = single_web_response(
                    course_gotten, prev_course, next_course)
                for i in ["thubmnail", "sm_thubmnail"]:
                    response.pop(i)
            else:
                response = single_web_response(
                    course_gotten, prev_course, next_course)
                list_ = ["prerequisites", "venue",
                        "active_course", "objectives", "audience"]
                for i in list_:
                    response.pop(i)
                if course_gotten.course_tab == "Free":
                    response.pop("thubmnail")
                    response.pop("sm_thubmnail")
                else:
                    response.pop("video_link")
            return Response(
                response,
                status=status.HTTP_200_OK,
            )
        except Courses.DoesNotExist:
            return Response(
                {"Error": "Course does not exist. Please check the cid provided"},
                status=status.HTTP_400_BAD_REQUEST,
            )
        except KeyError as e:
            return Response(
                {"Error": "cid field is missing"},
                status=status.HTTP_400_BAD_REQUEST,
            )


@api_view(["POST"])
@permission_classes((IsAuthenticated,))
def premium_link(request):
    # check user subscription:
    user_sub = Subscription.objects.filter(user=request.user)
    if user_sub and user_sub.first().subscribed:
        cid = request.data.get("cid")
        if cid:
            try:
                course = Courses.objects.get(cid=cid)
                serializer = prmiumlinkSerialiser(course)
                return Response(serializer.data)
            except Courses.DoesNotExist:
                return Response({"response", "No course with the cid supplied"})
        else:
            return Response({"response": "no cid supplied"}, status=status.HTTP_400_BAD_REQUEST)
    else:
        return Response({"response": "user not subscribed"}, status=status.HTTP_400_BAD_REQUEST)


@api_view(["GET"])
def course_schedule(request):
    if request.method == "GET":
        # TODO: cache implementation
        course_list = cache.get("course_schedule")
        if course_list is None:
            course_list = Courses.objects.filter(course_tab="Webinar").order_by(
                "category", "title"
            )
            cache.set("course_schedule", course_list)
        serializer = coursescheduleSerializer(course_list, many=True)
        data = {"pid": "schedule", "courses": serializer.data}
        return Response(data, status=status.HTTP_200_OK)


# Course Registration View
@course_registration_doc()
@api_view(["POST", "GET"])
@permission_classes((IsAuthenticated,))
def course_reg(request):

    # Register user for a course
    try:
        # Get course being registered for
        course = Courses.objects.get(cid=request.data["cid"])
    except (Courses.DoesNotExist, KeyError):
        return Response(
            {
                "response": "Course with the cid provided does not exist or cid field missing"
            },
            status=status.HTTP_400_BAD_REQUEST,
        )
    if request.method == "POST":

        # check if the user has registered for the course before
        if course_registred_user.objects.filter(
            user=request.user, course=course
        ).exists():
            return Response(
                {"response": "You have registered for the course"},
                status=status.HTTP_400_BAD_REQUEST,
            )
        registration_deadline = course.reg_end_date
        if (
            registration_deadline.date() >= timezone.now().date()
            and course.active_course
        ):
            serializer = course_registred_userSerializer(data=request.data)
            data = {}
            if serializer.is_valid():
                course_user = serializer.save()
                reference_id = course_user.reference_id
                number_of_slots = course_user.number_of_slots
                if int(number_of_slots) > 1:
                    # Save other participants
                    save_other_participants(
                        request, course_user, number_of_slots)

                course_user.user = request.user
                course_user.course = course
                try:
                    active_batch = (
                        course_batch.objects.filter(course=course)
                        .order_by("-pk")
                        .first()
                        .batch_number
                    )
                except:
                    # Create a batch for the course if it does not exist
                    active_batch = course_batch.objects.create(
                        course=course,
                        batch_number="01",
                        next_batch_date=course.course_end_date,
                        next_batch_time=" ",
                    )
                    active_batch = active_batch.batch_number
                course_user.batch_no = active_batch
                course_user.start_date = course.course_start_date
                course_user.end_date = course.course_end_date
                # check if course price is free
                if course.price == 0:
                    reg_id = "FWC/" + timezone.now().strftime('%Y%m%d') + "/" + str(course_user.pk)
                    # send email to user
                    course_email(course_user, reg_id)
                    course_user.pay_later = False
                    course_user.paid = True

                else:
                    reg_id = (
                        f"NLAP.{uuid.uuid4().hex[5:10]}.{timezone.now().strftime('%Y%m%d')}"
                    )
                    # To come with the payment post request
                    data["ref_id"] = reference_id
                course_user.registration_id = reg_id
                course_user.save()
                data["status"] = "Course Registration successfull"
                return Response(data, status=status.HTTP_201_CREATED)
            else:
                data = serializer.errors
                return Response(data, status=status.HTTP_400_BAD_REQUEST)
        else:
            return Response(
                {"response": "Registration is not on for this course or course not active for registration"},
                status=status.HTTP_400_BAD_REQUEST,
            )

    # Get the list of registerd users for all courses  -> To be modified
    if request.method == "GET":
        registered_students = course_registred_user.objects.all().order_by(
            "-date_registered"
        )
        serializer = course_registred_userSerializer(
            registered_students, many=True)
        return Response(serializer.data, status=status.HTTP_200_OK)


# Project Views
@parser_classes([MultiPartParser, FormParser])
@project_submission_doc()
@api_view(["POST"])
@permission_classes((IsAuthenticated,))
def projectview(request):

    if request.method == "POST":
        serializer = projectSerializer(data=request.data)
        data = {}
        if serializer.is_valid():
            project_save = serializer.save()
            project_save.user = request.user
            project_save.save()
            send_submission_email = project_email(project_save)
            # message nubyira also
            project_email_admin(project_save)
            data[
                "response"
            ] = "Project submitted successfully, An email has been sent for further instruction"
            return Response(data, status=status.HTTP_200_OK)
        else:
            return Response(
                {"error": serializer.errors, "response": "Project submission failed"},
                status=status.HTTP_400_BAD_REQUEST,
            )


@project_list_doc()
@api_view(["POST"])
def project_list_view(request):
    try:
        # Get the current page number
        page_number = request.data["page"]
        data = {}
        # Get all projects
        # TODO: cache implemetation
        all_projects = cache.get("project_list")
        if all_projects is None:
            all_projects = project.objects.order_by(
                "-pk", "project_completion_date", "project_nature", "project_title")
            cache.set("project_list", all_projects)
        # Return 6 per page
        paginator = Paginator(all_projects, 6)
        page_result = paginator.get_page(page_number)
        serializer = executed_projectSerializer(
            page_result.object_list, many=True)
        data.update(
            {
                "total_pages": paginator.num_pages,
                "current_page": page_result.number,
                "has_prev_page": page_result.has_previous(),
                "has_next_page": page_result.has_next(),
                "projects": serializer.data,
                "pid": "projects",
            }
        )
        return Response(data, status=status.HTTP_200_OK)
    except KeyError:
        return Response(
            {"response": "page number missing"}, status=status.HTTP_400_BAD_REQUEST
        )


@api_view(["GET"])
@permission_classes((AllowAny,))
def project_excuted(request):

    if request.method == "GET":
        # TODO: cache
        projects = cache.get("projects")
        if projects is None:
            projects = project.objects.filter(
                executed=True).order_by("-pk", "project_completion_date")
            cache.set("projects", projects)
        serializer = executed_projectSerializer(projects, many=True)

        response = {"pid": "projects", "response": serializer.data}
        return Response(response, status=status.HTTP_200_OK)


@project_executed_doc()
@api_view(["POST"])
def get_project(request):
    if request.method == "POST":
        prid = request.data["prid"]
        # cache TODO
        # Get project
        gotten_project = project.objects.filter(prid=prid).first()

        serializer = detail_projectSerializer(gotten_project)
        data = {"pid": "project-details", "response": serializer.data}
        return Response(data, status=status.HTTP_200_OK)


@api_view(["GET"])
@permission_classes((IsAuthenticated,))
def subscription(request):
    """This endpoint gives the payment details for a project subscription for both paystack and paypal"""
    key = os.environ.get(
        "key")
    client_id = os.environ.get("client-id")
    email = request.user.email
    name = request.user.get_full_name()
    reference = uuid.uuid4().hex

    if request.method == "GET":
        paystack_price = int(os.environ.get("sub_price")) * 100
        '''(
            int(os.environ.get("sub_price")) *
            100 * int(os.environ.get("rate"))
        )'''
        paypal_price = os.environ.get("sub_price")

        old_project_payments = payment.objects.filter(
            user=request.user, payment_for="subscription"
        )
        old_project_payments.delete()
        create_payment = payment.objects.create(
            user=request.user,
            reference_number=reference,
            amount=paystack_price,
            status="pending",
            payment_for="subscription",
        )
        data = {
            "paystack_price": paystack_price,
            "paypal_price": paypal_price,
            "paystack_key": key,
            "paypal_client_id": client_id,
            "email": email,
            "name": name,
            "ref_id": reference,
        }
    return Response(data, status=status.HTTP_200_OK)


@api_view(["GET"])
@permission_classes((IsAuthenticated,))
def subscription_status(request):
    """This return the status value for a registered project subscription"""
    subscription, created = Subscription.objects.get_or_create(
        user=request.user)
    
    # check and perform sub validation permission
    if subscription.last_sub_date and subscription.subscribed:
        sub_ends = subscription.last_sub_date + timedelta(days=subscription.max_number_of_days)
        if sub_ends < timezone.now():
            subscription.subscribed = False
            subscription.save()
    return Response(
        {"sub_status": subscription.subscribed}, status=status.HTTP_200_OK
    )


@download_report()
@api_view(["POST"])
@permission_classes((IsAuthenticated,))
def downloadfile(request):
    # check if the user is subscribed
    try:
        user_subscription = Subscription.objects.get(user=request.user)
    except Subscription.DoesNotExist:
        return Response({"Error": "User not subscribed"}, status=status.HTTP_400_BAD_REQUEST)
    # Get the prid and cid
    prid = request.data.get("prid")
    cid = request.data.get("cid")
    if user_subscription.subscribed:
        # if prid then get the project files
        if prid:
            # Get the project to download the file
            project_requested_for = project.objects.filter(prid=prid).first()
            # Get the project files
            file_name = project_requested_for.first().project_title
            try:
                project_files = Project_files.objects.get(
                    project_for=project_requested_for)
            except Project_files.DoesNotExist:
                return Response(
                    {"Error": "No files found"}, status=status.HTTP_400_BAD_REQUEST
                )
            gotten_files = project_files.project_report
        elif cid:
            course_requested_for = Courses.objects.filter(cid=cid)
            file_name = course_requested_for.first().title
            if course_requested_for:
                if course_requested_for.first().files:
                    gotten_files = course_requested_for.first().files
                else:
                    return Response(
                        {"Error": "No files found"}, status=status.HTTP_400_BAD_REQUEST
                    )
            else:
                return Response({"response": "No course with the supplied cid"}, status=status.HTTTP_400_BAD_REQUEST)
        else:
            return Response({'response': "cid or prid is needed"}, status=status.HTTP_400_BAD_REQUEST)
        url = str(gotten_files.url)
        opener = urlopen(url)
        if url[-3:] == "zip":
            ext = "zip"
        else:
            ext = url[-3:]
        response = HttpResponse(
            opener.read(), content_type=f'application/{url[-3:]}')
        # return FileResponse(
        #     open(url, 'rb'), as_attachment=True, filename=file_name)
        response["Content-Disposition"] = f"attachment; filename=nubyira.{url[-3:]}"
        # wget.download(gotten_files.url)
        return response
    else:
        return redirect("https://nubyira.com/pages/projects.html")


# Payment Views
@payment_info_doc()
@permission_classes((IsAuthenticated,))
@api_view(["POST"])
def payment_info(request):

    if request.method == "POST":
        try:
            ref_id = request.data["ref_id"]
            registered_user = course_registred_user.objects.filter(
                reference_id=ref_id
            ).first()
            course = registered_user.course
            total_payment = registered_user.number_of_slots * course.price
            if course.coupon_code:
                coupon_code = True
            else:
                coupon_code = False
            if registered_user.number_of_slots > 1:
                course_token = (
                    str(course.price)
                    + " x "
                    + str(registered_user.number_of_slots)
                    + " slots"
                )
            else:
                course_token = (
                    str(course.price)
                    + " x "
                    + str(registered_user.number_of_slots)
                    + " slot"
                )
            name, email, amount, key, ref_id = deposit(ref_id)
            client_id = os.environ.get("client-id")
            data = {
                "course_token": course_token,
                "course_title": course.title,
                "course_category": course.category,
                "total_payment": total_payment,
                "coupon_code": coupon_code,
                "name": name,
                "email": email,
                "amount": amount,
                "key": key,
                "ref_id": ref_id,
                "client_id": client_id,
            }
            return Response(data, status=status.HTTP_200_OK)
        except KeyError:
            return Response(
                {"response": "ref_id is required"}, status=status.HTTP_400_BAD_REQUEST
            )


@pay_later_doc()
@permission_classes((IsAuthenticated,))
@api_view(["POST"])
def pay_later(request):
    user = request.user
    try:
        later = request.data["later"]
        ref_id = request.data["ref_id"]
    except KeyError:
        return Response({"response": "later or ref_id field missing"})
    reg_course = course_registred_user.objects.filter(
        reference_id=ref_id, user=user
    ).first()
    if later:
        reg_course.pay_later = True
    else:
        reg_course.pay_later = False
    reg_course.save()
    return Response(
        {"success": "Payment status updated to pay later"}, status=status.HTTP_200_OK
    )


@api_view(["GET"])
def confirm_payment(request):
    access_token = get_access_token()
    detail_id = request.GET.get("detail_id")
    url = f"https://www.paypal.com/v2/checkout/orders/{detail_id}"
    prid = request.GET.get("prid")
    cid = request.GET.get("cid")
    headers = {"Authorization": f"Bearer {access_token}"}
    response = requests.request("GET", url, headers=headers)
    response = json.loads(response.text)
    status = response.get("status")
    if status == "COMPLETED":
        ref_id = response["purchase_units"][0]["invoice_id"]
        status = request.GET.get("status")
        if status == "subscription" and prid:
            return subscribed(ref_id, prid)
        elif status == "subscription" and cid:
            return subscribed(ref_id, cid)
        else:
            return run_work(ref_id)
    else:
        return redirect("https://nubyira.com/pages/learn.html?payment_status=abandoned")


@blog_post_doc()
@api_view(["POST"])
def blogpost(request):

    # paginator = PageNumberPagination()
    # paginator.page_size = 4
    if request.method == "POST":
        page_number = request.data.get("page", 1)
        blog_list = blogs.objects.filter(status="Published").order_by("-pk")

        for entry in blog_list:
            entry.content = (
                entry.content.replace("\r\n\r\n", "")
                .replace("\r\n\t", "")
                .replace("&nbsp;", "")
            )
        response = paginate(blog_list, page_number,
                            blogSerializer, model="blogs")
        data = {"pid": "blog", "response": response}
        return Response(data, status=status.HTTP_200_OK)


def get_recommend_posts(serializer):
    count = blogs.objects.all().count()
    # get recommended blogs by date published receent-oldest
    recommended_by_date_published = blogs.objects.filter(status="Published").order_by(
        "-date_published", "views")[:count//2]
    ids = [entry.id for entry in recommended_by_date_published]
    new_count = count - count//2
    recommended_by_view = blogs.objects.filter(status="Published").order_by(
        "views").exclude(id__in=ids)[:new_count]
    recommended_by_date_published_ser = serializer(
        recommended_by_date_published, many=True)
    recommended_by_views_ser = serializer(
        recommended_by_view, many=True)
    recommend = {"recommend": list(recommended_by_date_published_ser.data)}
    recommend["recommend"].extend(list(recommended_by_views_ser.data))

    return recommend


@ blog_post()
@ api_view(["POST"])
def blogpostdetails(request):

    if request.method == "POST":
        bid = request.data["bid"]
        blog = blogs.objects.filter(
            pk=bid, status="Published").order_by("-pk").first()

        blog.full_content = (
            blog.full_content.replace("\r\n\r\n", "")
            .replace("\r\n\t", "")
            .replace("&nbsp;", "")
            .replace("\r\n", "")
        )
        prev_blog, next_blog = prev_next(blog, "blog")
        serializer = blog_detailSerializer(blog)
        recommend = get_recommend_posts(RecommendedBlogSerializer)
        more_posts = get_recommend_posts(MoreBlogSerializer)
        data = {
            "pid": "blog-detail",
            "response": serializer.data,
            "recommend": recommend['recommend'],
            "more_posts": more_posts['recommend'],
            "prev_bid": prev_blog,
            "next_bid": next_blog,
        }
        blog.views += 1
        blog.save()
        return Response(data, status=status.HTTP_200_OK)


# Paypal View
@ deposit_post_doc()
@ api_view(["POST"])
@ permission_classes((IsAuthenticated,))
def paypal(request):

    if request.method == "POST":
        user = request.user
        reference_id = request.data["ref_id"]
        # Generate another reference id to prevent the one coming from front end in case of being tempered with
        user_reference_number = str(uuid.uuid4().hex)
        course_object = course_registred_user.objects.get(
            reference_id=reference_id)
        slot_number = course_object.number_of_slots
        phone = user.phone_number
        amount = int(course_object.course.price) * slot_number
        email = user.email
        user_payment = payment(
            user=user,
            amount=amount,
            status="pending",
            reference_number=user_reference_number,
        )
        user_payment.save()
        # Attach the reference number to the user account
        course_object.payment_reference_id = user_reference_number
        course_object.save()
    return render(
        request, "paypal.html", {"amount": amount,
                                 "ref_id": user_reference_number}
    )


# User Dashboard endpoint view

@ cache_page(60 * 5)
@ parser_classes([MultiPartParser, FormParser])
@ dashboard_doc()
@ api_view(["GET", "POST", "DELETE"])
@ permission_classes((IsAuthenticated,))
def dashboard(request):
    """
    Dashboard endpoint: This endpoint returns the users primary information (first_name, last_name, email and image), course
       user has registered for, blogs saved by user for future readings and project subscription status either subscribed or not.
       \n It uses get method to fetch all the details for only logged in users i.e it expects token key of the user
       \n The post method is for the user to save a blog post which expects the user to be logged in and alos the title of the blog should be sent as a body parameter
    """
    # Get the logged in user
    user = request.user

    if request.method == "GET":

        # user primary info
        primary_info = {
            "full_name": f"{user.first_name} {user.last_name} {user.middle_name}",
            "email": user.email,
        }
        if user.image:
            serializer = ImageSerializer(user)
            primary_info.update({"image": serializer.data["image"]})

        # Courses registered for by user
        user_courses = course_registred_user.objects.filter(user=user)
        courses_info = {}
        registered_courses = []

        for course_registered in user_courses:
            if course_registered.pay_later:
                course_status = "Awaiting Payment"
            elif course_registered.completed:
                course_status = "Completed"
            elif course_registered.postponed:
                course_status = (
                    "Valid"
                    if course_registered.end_date > timezone.now().date()
                    else "Expired"
                )
            else:
                course_status = "Not Completed"

            other_participants = extra_participant.objects.filter(
                registra=course_registered
            )
            if other_participants:
                other_participant_serializer = ExtraparticipantSerializer(
                    other_participants, many=True
                )
            if not course_registered.archived:
                registered_courses.append(
                    {
                        "cid": course_registered.course.cid,
                        "course_title": course_registered.course.title,
                        "course_cat": course_registered.course.category,
                        "registration_id": course_registered.registration_id,
                        "slot": course_registered.number_of_slots,
                        "price": course_registered.course.price
                        * course_registered.number_of_slots,
                        "start_date": course_registered.start_date.strftime("%d/%m/%y"),
                        "end_date": course_registered.end_date.strftime("%d/%m/%y"),
                        "time": course_registered.course.time,
                        "status": course_status,
                        "certificate": "Available"
                        if course_registered.certificate
                        else "Not Available",
                        "other_participants": other_participant_serializer.data
                        if other_participants
                        else "None",
                        "payment_ref_id": course_registered.reference_id
                        if course_registered.pay_later
                        else "None",
                        "postponed": course_registered.postponed,
                    }
                )

            if course_registered.completed:
                registered_courses[len(registered_courses) - 1].update(
                    {"attendance": course_registered.attendance}
                )

        if registered_courses:
            courses_info.update({"registered_courses": registered_courses})

        project_subscribed = (
            Subscription.objects.filter(
                user=user).first()
        )
        
        if project_subscribed: project_subscribed = project_subscribed.subscribed
        else:project_subscribed = False
        # blog svaed by user
        user_blogs = saved_blogs.objects.filter(
            user=user).order_by("-date_saved")
        blogs_saved = {}
        for entry in user_blogs:
            for blog in entry.blog.all():
                blogs_saved[blog.bid] = {
                    "id": blog.id,
                    "title": blog.title,
                    "content": blog.content.replace("\r\n\r\n", "")
                    .replace("\r\n\t", "")
                    .replace("&nbsp;", "")
                    .replace("\r\n", ""),
                }

        response = {
            "primary_info": primary_info,
            "project_subscription": project_subscribed,
            "course_info": courses_info,
        }
        if blogs_saved:
            response.update({"blogs_saved": blogs_saved})
        # if courses_info:
        #     response.update({"course_info": courses_info})

        return Response(response, status=status.HTTP_200_OK)

    elif request.method == "POST":
        try:
            bid = request.data["bid"]
            gotten_blog = blogs.objects.get(pk=bid)
            save_blog, created = saved_blogs.objects.get_or_create(user=user)
            save_blog.blog.add(gotten_blog)
            return Response(
                {"Success": "Blog saved successfully"}, status=status.HTTP_200_OK
            )
        except (blogs.DoesNotExist, ValueError):
            return Response(
                {"Error": "Blog post with the given bid does not exist"},
                status=status.HTTP_400_BAD_REQUEST,
            )

    elif request.method == "DELETE":
        try:
            bid = request.data["bid"]
            gotten_blog = blogs.objects.get(pk=bid)
            save_blog = saved_blogs.objects.get(user=user)
            save_blog.blog.remove(gotten_blog)
            return Response(
                {"Success": "Blog removed successfully"}, status=status.HTTP_200_OK
            )
        except (blogs.DoesNotExist, ValueError):
            return Response(
                {"Error": "Blog post with the given bid does not exist"},
                status=status.HTTP_400_BAD_REQUEST,
            )


@ api_view(["POST"])
@ permission_classes((IsAuthenticated,))
def uploadAvatar(request):
    avatar = request.data["avatar"]
    user = User.objects.filter(email=request.user.email).first()
    user.image = avatar
    user.save()
    return Response({"Response": "Image Upload successful"}, status=status.HTTP_200_OK)


@ postpone_course_doc()
@ api_view(["POST", "DELETE", "PUT"])
@ permission_classes((IsAuthenticated,))
def postpone_course(request):
    try:
        reg_id = request.data.get("reg_id")
        db_reg_obj = course_registred_user.objects.get(registration_id=reg_id)
    except course_registred_user.DoesNotExist:
        return Response(
            {"response": f"No registered user with the given reg_id of {reg_id}"},
            status=status.HTTP_400_BAD_REQUEST,
        )

    # Pospone a course
    if request.method == "POST":
        if (
            not db_reg_obj.completed
            and db_reg_obj.paid
            and db_reg_obj.end_date > timezone.now().date()
        ):
            db_reg_obj.postponed = True
            db_reg_obj.save()
            return Response(
                {"response": "Course Posponed Successfully"}, status=status.HTTP_200_OK
            )
        else:
            return Response(
                {"response": "Course can't be posponed again"},
                status=status.HTTP_400_BAD_REQUEST,
            )

    # Delete a posponed course
    if request.method == "DELETE":
        if (
            db_reg_obj.postponed
            and not db_reg_obj.completed
            and db_reg_obj.end_date < timezone.now().date()
        ):
            # Archive the course
            db_reg_obj.archived = True
            db_reg_obj.save()
            return Response(
                {"response": "Course Deleted Successfully"},
                status=status.HTTP_204_NO_CONTENT,
            )
        elif db_reg_obj.end_date > timezone.now().date() and db_reg_obj.postponed:
            return Response(
                {
                    "response": "Course can still be taken or activated because it's still on"
                },
                status=status.HTTP_200_OK,
            )
        else:
            return Response(
                {"response": "No deletion done"}, status=status.HTTP_400_BAD_REQUEST
            )

    # Reactivate a posponed course
    if request.method == "PUT":
        if db_reg_obj.archived:
            return Response(
                {"response": "Contact admin for activation"},
                status=status.HTTP_400_BAD_REQUEST,
            )
        else:
            db_reg_obj.postponed = False
            db_reg_obj.save()
            return Response(
                {"response": "Course Activated Successfully"}, status=status.HTTP_200_OK
            )


@ download_certificate_doc()
@ api_view(["POST"])
@ permission_classes((IsAuthenticated,))
def download_certificate(request):
    try:
        # Get the reg_id of the registered user
        reg_id = request.data["reg_id"]
        # Get the registered course object to check for certificate availability
        reg_obj = course_registred_user.objects.get(registration_id=reg_id)
        if reg_obj.certificate and reg_obj.completed:
            certificate_gotten = course_certificate.objects.get(
                reg_obj=reg_obj)
            url = str(certificate_gotten.certificate_file.url)
            openurl = urlopen(url)
            if url[-3:] in ["png", "jpg", "jpeg"]:
                content_type = f"image/{url[-3:]}"
            else:
                content_type = f"application/{url[-3:]}"
            response = HttpResponse(openurl.read())
            response["Content-Type"] = content_type
            response[
                "Content-Disposition"
            ] = f"attachment; filename={reg_obj.course.title}.{url[-3:]}"
            return response
        else:
            return Response(
                {
                    "response": "Sorry certificate is not available or course is yet to be completed"
                },
                status=status.HTTP_400_BAD_REQUEST,
            )
    except KeyError:
        return Response(
            {"response": "reg_id is not seen"}, status=status.HTTP_400_BAD_REQUEST
        )
    except course_registred_user.DoesNotExist:
        return Response(
            {"response":
                f"No registration found with the reg_id ({reg_id}) given"},
            status=status.HTTP_400_BAD_REQUEST,
        )
    except course_certificate.DoesNotExist:
        return Response(
            {"response": "Cerficate file not found"}, status=status.HTTP_400_BAD_REQUEST
        )


def get_image(names, cert):
    from PIL import Image, ImageDraw, ImageFont
    import urllib.request
    from django.http import FileResponse
    font = ImageFont.truetype('arial.ttf', 60)
    for full_name in names:
        urllib.request.urlretrieve(cert, "cert.png")
        # img = urlopen(cert)
        img = Image.open("cert.png")
        draw = ImageDraw.Draw(img)
        draw.text(xy=(725, 760), text=f'{full_name}', fill=(
            0, 0, 0), font=font)
        # img.seek()
        response = HttpResponse(img)
        # response = FileResponse(img, as_attachment=True, filename="file.png")
        response["Content-Type"] = f"image/png"
        response[
            "Content-Disposition"
        ] = f"attachment; filename={full_name}.png"
        return response
        # img.save(f'pictures/{full_name}.jpg')
        # img.show()


@ register_certificate_doc()
@ api_view(["POST"])
@ permission_classes((IsAuthenticated,))
def register_certificate(request):

    if request.user.is_staff:
        try:
            reg_id = request.data["reg_id"]
            # fetch the course_reg
            course_reg = course_registred_user.objects.filter(
                registration_id=reg_id).first()
            if course_reg:
                full_name = f"{course_reg.first_name} {course_reg.last_name}"
                return get_image(
                    [full_name], 'https://res.cloudinary.com/hrh5zmmzu/image/upload/v1649012741/media/Certificates/certificate_sdzgwj.jpg')
            else:
                return Response(
                    {"response": f"No registration associated with the reg_id({reg_id}) provided"},
                    status=status.HTTP_400_BAD_REQUEST,
                )
            if course_reg.number_of_slots > 1:
                # Get the name of other participant
                other_name = extra_participant.objects.filter(
                    registra=course_reg, course=course_reg.course)
                other_name_list = [entry.first_name +
                                   entry.last_name for entry in other_name]
                get_image(other_name_list, 'certificate.jpg')

            # on the certificate field in the reg_obj
            course_reg.certificate = True

            # On the completed field if given to be true
            course_reg.completed = True
            course_reg.save()
            return Response(
                {"response": "Certificate generated successfully"}, status=status.HTTP_200_OK
            )
        except KeyError:
            return Response(
                {"response": "reg_id or certifatce file or completed filed missing"},
                status=status.HTTP_400_BAD_REQUEST,
            )
    else:
        return Response(
            {"response": "You can't upload certificate"},
            status=status.HTTP_400_BAD_REQUEST,
        )


@ attendance_doc()
@ api_view(["POST"])
@ permission_classes((IsAuthenticated,))
def attendance(request):
    if request.user.is_staff:
        if request.method == "POST":
            try:
                reg_id = request.data["reg_id"]
                course_reg_obj = course_registred_user.objects.get(
                    registration_id=reg_id
                )
                course_reg_obj.attendance += 1
                course_reg_obj.save()
                return Response(
                    {"response": "Attendance marked successfully"},
                    status=status.HTTP_200_OK,
                )
            except KeyError:
                return Response(
                    {"response": "reg_id not seen"}, status=status.HTTP_400_BAD_REQUEST
                )
            except course_registred_user.DoesNotExist:
                return Response(
                    {"response": f"No registration found with the give id {reg_id}"},
                    status=status.HTTP_400_BAD_REQUEST,
                )
    else:
        return redirect("https://nubyira.com")


def doc_login(request):
    user = request.user
    if user.is_authenticated:
        return redirect("schema-swagger-ui")

    if request.method == "POST":
        email = request.POST["email"]
        password = request.POST["password"]
        user = authenticate(request, email=email, password=password)
        if user and user.is_staff:
            login(request, user)
            if user.email == "princeodia@gmail.com":
                return redirect("schema-swagger-ui")
            else:
                return redirect("/")
        else:
            return redirect("doc_login")

    return render(request, "login.html")


@ ads_post_doc()
@ api_view(["GET", "POST"])
def getAds(request):
    if request.method == "GET":
        ads = Ads.objects.all()
    if request.method == "POST":
        ads = Ads.objects.filter(page=request.data.get('page'))

        if not ads:
            return Response({"response": "Are you sure you supply the correct page name"}, status=status.HTTP_400_BAD_REQUEST)
    serializer = AdsSerializer(ads, many=True)
    return Response(serializer.data)


def view_404(request, exception):

    return render(request, "404.html")


def view_500(request):

    return render(request, "500.html")


def mail_user(request, cid):
    course = Courses.objects.get(cid=cid)
    for course_obj in course_registred_user.objects.filter(course=course):
        course_email(course_obj, course_obj.registration_id)
    return HttpResponse("updated mail has been sent to users")
