# Standard Python library imports.
import math
import re

# Core Django imports.
from django.utils.html import strip_tags


def count_words(html_string):
    # html_string = """
    # <h1>This is a title</h1>
    # """
    word_string = strip_tags(html_string)
    matching_words = re.findall(r'\w+', word_string)
    count = len(matching_words)  # joincfe.com/projects/
    return count


def read_time(html_string):
    count = count_words(html_string)  # This returns the length of the text
    # assuming 200wpm reading, rounding the result upward to the nearest integer
    read_time_min = math.ceil(count/200.0)
    # read_time_sec = read_time_min * 60
    # read_time = str(datetime.timedelta(seconds=read_time_sec))
    # read_time = str(datetime.timedelta(minutes=read_time_min))
    time = 'min' if read_time_min == 1 else "mins"
    return f"{read_time_min} {time}"
