from django.urls import path
from .views import *
from .admin_views import *
from .payment import *
# app_name = "api"

urlpatterns = [
    path("access/<str:user_id>/<str:action>", access, name="access"),
    path("admin/all_users/", all_users, name="all_users"),
    path("send_user_email/", admin_send_user_email, name="admin_send_user_email"),
    path("admin_payment/", admin_payment, name="admin_payment"),
    path("sub_user/<str:user_id>/<str:status>/", sub_user, name="sub_user"),
    path("admin_blogs/", admin_blogs, name="admin_blogs"),
    path("edit_blogs/<int:blog_id>/", edit_blogs, name="edit_blog"),
    path("edit_projects/<int:project_id>/",
         edit_projects, name="edit_projects"),
    path("edit_course/<int:course_id>/", edit_course, name="edit_course"),
    path("delete_blogs/<int:blog_id>/", delete_blog, name="delete_blog"),
    path("delete_course/<int:course_id>/", delete_course, name="delete_course"),
    path("admin_courses/", admin_course, name="admin_courses"),
    path("admin_projects/", projects, name="projects"),
    path("admin_course_registered/", admin_course__user_registered,
         name="admin_course_registered"),
    # Authentication Endpoint
    path("register/", register, name="register"),
    path("login/", Loginview, name="Login"),
    path("admin_logout/", Logout, name="Logout"),
    path("logout/", logout_user, name="logout"),
    path("authenticate/", authenticate_user, name="authenticate"),
    # Email confirmation
    path(
        "activate/<str:user_status>/<uidb64>/<token>/",
        activate_mail,
        name="activate_mail",
    ),
    path(
        "resend-confirmation-link/",
        resend_activation_link,
        name="resend_activation_link",
    ),
    # Password Reset
    path(
        "reset-password/",
        reset_password,
        name="reset_password",
    ),
    path(
        "reset/<uidb64>/<token>",
        password_reset_link_confirmation,
        name="password_reset_confirm",
    ),
    path(
        "password-reset-confirm/", password_reset_confirm, name="password_reset_confirm"
    ),
    # Courses endpoints
    path("course-info/", course_info),
    path("courses/", course_view, name="course_view"),
    path("single-course/", get_course, name="get_course"),
    path("course-schedule/", course_schedule, name="course_schedule"),
    path("course-reg/", course_reg, name="course_reg"),
    path("allCoursesList/", allCoursesList, name="allCoursesList"),
    # Projects endpoits
    path("project/", projectview, name="projectview"),
    path("executed-projects", project_excuted),
    path("project-list/", project_list_view, name="project_list_view"),
    path("get-project/", get_project, name="get_project"),
    path("subscription/", subscription,
         name="project_subscription"),
    path(
        "get-subscription-status/",
        subscription_status,
        name="project_subscription_status",
    ),
    path("prmium_link/", premium_link, name="premium_link"),
    path("downloadfile/", downloadfile, name="downloadfile"),
    # Payment endoints
    path("payment-info/", payment_info, name="payment_info"),
    path("pay-later/", pay_later, name="pay_later"),
    path(
        "confirm_paystack_payment/",
        confirm_paystack_payment,
        name="confirm_paystack_payment",
    ),
    path("paystack/", deposit, name="paystack"),
    path("confirm-payment/", confirm_payment, name="confirm_payment"),
    path("paypal/", paypal, name="paypal"),
    # path('complete-paypal/', complete_paypal, name = 'complete_paypal')
    # Blog endpoint
    path("blogs/", blogpost, name="blogpost"),
    path("blog-detail/", blogpostdetails, name="blogpostdetails"),
    # Dashboard endpoint
    path("dashboard/", dashboard, name="dashboard"),
    path("uploadAvatar", uploadAvatar, name="uploadAvatar"),
    path("certificate/", download_certificate, name="download_certificate"),
    path("postpone-course/", postpone_course, name="postpone_course"),
    path("take-attendance/", attendance, name="attendance"),
    path("upload-certificate/", register_certificate,
         name="register_certificate"),
    path("generate_cid/", generate_cid_view),
    path('ads/', getAds),
    path("mail_user/<str:cid>/", mail_user),
    path("sort_filter/", sort_filter, name = "sort_filter"),
    # path("loc/", loc_req)
]
