from django.test import TestCase
from django.urls import resolve
from django.urls import reverse
from api.views import (
    register,
    Loginview,
    activate_mail,
    course_view,
    confirm_paystack_payment,
    payment_info,
    pay_later,
    uploadAvatar,
    downloadfile,
    course_reg,
    projectview,
    deposit,
    blogpostdetails,
    project_subscription,
    project_subscription_status,
    confirm_payment,
    reset_password,
    password_reset_link_confirmation,
    dashboard,
    postpone_course,
    password_reset_confirm,
    blogpost,
    paypal,
    logout,
    register_certificate,
    resend_activation_link,
    download_certificate,
    get_course,
    authenticate_user,
    course_schedule,
    attendance,
    project_list_view,
    get_project,
)


class UrlsTestClass(TestCase):
    def test_register_url_resolves(self):
        url = resolve(reverse("register"))
        self.assertEqual(url.func, register)

    def test_login_url_resolves(self):
        url = resolve(reverse("Login"))
        self.assertEqual(url.func, Loginview)

    def test_logout_url_resolves(self):
        url = resolve(reverse("logout"))
        self.assertEqual(url.func, logout)

    def test_authenticate_url_resolves(self):
        url = resolve(reverse("authenticate"))
        self.assertEqual(url.func, authenticate_user)

    def test_activate_mail_url_resolves(self):
        url = resolve(
            reverse("activate_mail", args=["shshs", "ajsjs8-jwu8", "shsjsksj"])
        )
        self.assertEqual(url.func, activate_mail)

    def test_resend_activation_link_url_resolves(self):
        url = resolve(reverse("resend_activation_link"))
        self.assertEqual(url.func, resend_activation_link)

    def test_reset_password_url_resolves(self):
        url = resolve(reverse("reset_password"))
        self.assertEqual(url.func, reset_password)

    def test_password_reset_confirm_url_resolves(self):
        url = resolve(reverse("password_reset_confirm"))
        self.assertEqual(url.func, password_reset_confirm)

    def test_password_reset_confirm_url_resolves(self):
        url = resolve(reverse("password_reset_confirm"))
        self.assertEqual(url.func, password_reset_confirm)

    def test_course_view_url_resolves(self):
        url = resolve(reverse("course_view"))
        self.assertEqual(url.func, course_view)

    def test_get_course_url_resolves(self):
        url = resolve(reverse("get_course"))
        self.assertEqual(url.func, get_course)

    def test_course_schedule_url_resolves(self):
        url = resolve(reverse("course_schedule"))
        self.assertEqual(url.func, course_schedule)

    def test_course_reg_url_resolves(self):
        url = resolve(reverse("course_reg"))
        self.assertEqual(url.func, course_reg)

    def test_projectview_url_resolves(self):
        url = resolve(reverse("projectview"))
        self.assertEqual(url.func, projectview)

    def test_project_list_view_url_resolves(self):
        url = resolve(reverse("project_list_view"))
        self.assertEqual(url.func, project_list_view)

    def test_get_project_url_resolves(self):
        url = resolve(reverse("get_project"))
        self.assertEqual(url.func, get_project)

    def test_project_subscription_url_resolves(self):
        url = resolve(reverse("project_subscription"))
        self.assertEqual(url.func, project_subscription)

    def test_project_subscription_status_url_resolves(self):
        url = resolve(reverse("project_subscription_status"))
        self.assertEqual(url.func, project_subscription_status)

    def test_downloadfile_url_resolves(self):
        url = resolve(reverse("downloadfile"))
        self.assertEqual(url.func, downloadfile)

    def test_payment_info_url_resolves(self):
        url = resolve(reverse("payment_info"))
        self.assertEqual(url.func, payment_info)

    def test_pay_later_url_resolves(self):
        url = resolve(reverse("pay_later"))
        self.assertEqual(url.func, pay_later)

    def test_confirm_paystack_payment_url_resolves(self):
        url = resolve(reverse("confirm_paystack_payment"))
        self.assertEqual(url.func, confirm_paystack_payment)

    def test_paystack_url_resolves(self):
        url = resolve(reverse("paystack"))
        self.assertEqual(url.func, deposit)

    def test_confirm_payment_url_resolves(self):
        url = resolve(reverse("confirm_payment"))
        self.assertEqual(url.func, confirm_payment)

    def test_paypal_url_resolves(self):
        url = resolve(reverse("paypal"))
        self.assertEqual(url.func, paypal)

    def test_blogpost_url_resolves(self):
        url = resolve(reverse("blogpost"))
        self.assertEqual(url.func, blogpost)

    def test_blogpostdetails_url_resolves(self):
        url = resolve(reverse("blogpostdetails"))
        self.assertEqual(url.func, blogpostdetails)

    def test_dashboard_url_resolves(self):
        url = resolve(reverse("dashboard"))
        self.assertEqual(url.func, dashboard)

    def test_uploadAvatar_url_resolves(self):
        url = resolve(reverse("uploadAvatar"))
        self.assertEqual(url.func, uploadAvatar)

    def test_download_certificate_url_resolves(self):
        url = resolve(reverse("download_certificate"))
        self.assertEqual(url.func, download_certificate)

    def test_postpone_course_url_resolves(self):
        url = resolve(reverse("postpone_course"))
        self.assertEqual(url.func, postpone_course)

    def test_attendance_url_resolves(self):
        url = resolve(reverse("attendance"))
        self.assertEqual(url.func, attendance)

    def test_register_certificate_url_resolves(self):
        url = resolve(reverse("register_certificate"))
        self.assertEqual(url.func, register_certificate)
