from drf_yasg import openapi
from drf_yasg.utils import swagger_auto_schema


def register_post_doc():
    return swagger_auto_schema(
        operation_description="User registration endpoint",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['first_name', 'last_name',
                      'phone_number', 'email', 'password'],
            properties={
                'first_name': openapi.Schema(type=openapi.TYPE_STRING),
                'last_name': openapi.Schema(type=openapi.TYPE_STRING),
                'phone_number': openapi.Schema(type=openapi.TYPE_STRING),
                'email': openapi.Schema(type=openapi.TYPE_STRING),
                'password': openapi.Schema(type=openapi.TYPE_STRING),
                'middle_name': openapi.Schema(type=openapi.TYPE_STRING)
            },
        ),
        responses={200: "Registration Successfully, Please check your email for confirmation", 400: "Email:\nEmail already exist\n\nPhone_number Error\nPhone number already exist\ncoutry code missing or incorrect,\nCoutry code missing\nNumber does not exist\
            \n\nPassword Error\nPassword must be 8 characters long\nPassword should contains both numbers and letters"},
        security=[]

    )


def project_list_doc():
    return swagger_auto_schema(
        operation_description="Project pagination endpoint",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['page'],
            properties={
                'page': openapi.Schema(type=openapi.TYPE_STRING),
            },
        ),
        responses={200: "It returns the projects for the page number given",
                   400: "page number missing"},
        security=[]

    )


def login_post_doc():

    return swagger_auto_schema(
        operation_description="User Login Endpoint",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['email', 'password'],
            properties={
                'email': openapi.Schema(type=openapi.TYPE_STRING),
                'password': openapi.Schema(type=openapi.TYPE_STRING),
            },
        ),
        responses={200: "User first_name and token key will be returned", 401: "Unconfirmed Email:\nEmail not confirmed or user is not registered\
            \nWrong Inputs:\nUnable to login with provided credentials\nWrong Fields supplied:\nsupplied json field not valid for transaction"},

    )


def logout_post_doc():
    return swagger_auto_schema(
        operation_description="User Logout Endpoint: Format>>>{\"Authorization\":\"Token token_key\"}",
        methods=['POST'],
        responses={200: "User logged out successfully.",
                   400: "invalid token received"}

    )


def reset_password_doc():
    return swagger_auto_schema(
        operation_description="Password Reset Endpoint",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['email'],
            properties={
                'email': openapi.Schema(type=openapi.TYPE_STRING),
            },
        ),
        responses={200: "User is redirected to email setting page",
                   400: "User is redirected to get password reset link page"},

    )


def resend_conf_email_doc():
    return swagger_auto_schema(
        operation_description="Resend Email Confirmation Endpoint",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['email'],
            properties={
                'email': openapi.Schema(type=openapi.TYPE_STRING),
            },
        ),
        responses={200: "If user is registered an email has been sent.",
                   400: "If user is registered an email has been sent"},

    )


def password_reset_confirm_doc():
    return swagger_auto_schema(
        operation_description="Password Reset Confirm Endpoint",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['email', 'new_password', 'confirm_new_password'],
            properties={
                'email': openapi.Schema(type=openapi.TYPE_STRING),
                'new_password': openapi.Schema(type=openapi.TYPE_STRING),
                'confirm_new_password': openapi.Schema(type=openapi.TYPE_STRING),
            },
        ),
        responses={200: "Password reset successfully",
                   400: "Password rules broken or Passwords do not match"},

    )


def pay_later_doc():
    return swagger_auto_schema(
        operation_description="Pay later endpoint which expects the later option either True of False as value, \n ref_id is being expected as well",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['later', 'ref_id'],
            properties={
                'later': openapi.Schema(type=openapi.TYPE_STRING),
                'ref_id': openapi.Schema(type=openapi.TYPE_STRING),
            },
        ),
        responses={200: "Payment status updated to pay later",
                   400: "later or ref_id field missing"},

    )


def payment_info_doc():
    return swagger_auto_schema(
        operation_description="Payment info endpoint which return the neccessary info for the particular registered user. \n The ref_id is the one gotten after successful course registration",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['ref_id'],
            properties={
                'ref_id': openapi.Schema(type=openapi.TYPE_STRING),
            },
        ),
        responses={200: "returns the info requested for",
                   400: "ref_id not seen error will be thrown"},

    )


def course_registration_doc():
    return swagger_auto_schema(
        operation_description="Course Registration endpoint\n\nNote:\n\
            course field should be the course id\n\
            when number of slots is more than one the first_name, last_name and email fields of the other paticipants should\
                be send with the naming convention of first_name_2,last_name_2,email_2 middle_name_1(if provided) etc",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['cid', 'first_name', 'last_name', 'company_institution', 'email',
                      'professional_academic_field', 'country', 'number_of_slots'],

            properties={
                'cid': openapi.Schema(type=openapi.TYPE_STRING),
                'first_name': openapi.Schema(type=openapi.TYPE_STRING),
                'middle_name': openapi.Schema(type=openapi.TYPE_STRING),
                'last_name': openapi.Schema(type=openapi.TYPE_STRING),
                'company_institution': openapi.Schema(type=openapi.TYPE_STRING),
                'phone_number': openapi.Schema(type=openapi.TYPE_STRING),
                'email': openapi.Schema(type=openapi.TYPE_STRING),
                'zip_number': openapi.Schema(type=openapi.TYPE_STRING),
                'professional_academic_field': openapi.Schema(type=openapi.TYPE_STRING),
                "address": openapi.Schema(type=openapi.TYPE_STRING),
                "country": openapi.Schema(type=openapi.TYPE_STRING),
                'number_of_slots': openapi.Schema(type=openapi.TYPE_INTEGER),

            },
        ),
        responses={200: "Course Registration successfull with the ref_id returned",
                   400: "Registration is not on for this course \n\n\
                        You have registered for this course"},
        security=[]

    )


def project_submission_doc():
    return swagger_auto_schema(
        operation_description="Project submission endpoint\n For the project_type, bundle the selected values into a string separated\
        with comma and for project_nature the values are Full execution and Project assistance",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['project_title', 'first_name', 'last_name', 'company_university', 'phone_number', 'email',
                      'professional_academic_field', 'country', 'project_nature', 'project_type'],
            properties={
                'project_title': openapi.Schema(type=openapi.TYPE_STRING),
                'first_name': openapi.Schema(type=openapi.TYPE_STRING),
                'middle_name': openapi.Schema(type=openapi.TYPE_STRING),
                'last_name': openapi.Schema(type=openapi.TYPE_STRING),
                'company_university': openapi.Schema(type=openapi.TYPE_STRING),
                'phone_number': openapi.Schema(type=openapi.TYPE_STRING),
                'email': openapi.Schema(type=openapi.TYPE_STRING),
                'zip_number': openapi.Schema(type=openapi.TYPE_STRING),
                'professional_academic_field': openapi.Schema(type=openapi.TYPE_STRING),
                "address": openapi.Schema(type=openapi.TYPE_STRING),
                "country": openapi.Schema(type=openapi.TYPE_STRING),
                "project_nature": openapi.Schema(type=openapi.TYPE_STRING),
                'project_file': openapi.Schema(type=openapi.TYPE_FILE),
                'comment': openapi.Schema(type=openapi.TYPE_STRING),
                'project_type': openapi.Schema(type=openapi.TYPE_STRING)
            },
        ),
        responses={200: "Project submitted successfully, An email has been sent for further instruction",
                   400: "Project submission failed"},
        security=[]

    )


def project_executed_doc():
    return swagger_auto_schema(
        operation_description="This return the details of project that has been executed",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['prid'],
            properties={
                'prid': openapi.Schema(type=openapi.TYPE_STRING),
            },
        ),
        responses={200: "It will return the details",
                   400: "Project fetch failed"},
        security=[]

    )


def course_info_doc():
    return swagger_auto_schema(
        operation_description="This return the details of course",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['cid'],
            properties={
                'cid': openapi.Schema(type=openapi.TYPE_STRING),
            },
        ),
        responses={200: "It will return the details",
                   400: "course fetch failed"},
        security=[]

    )


def authenticate_doc():
    return swagger_auto_schema(
        operation_description="This is the endpoint to validate the user's login status. It requires the token key in the header.\
            if token is invalid,the user has to get the new token using the login endpoint",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            properties={
                'pid': openapi.Schema(type=openapi.TYPE_STRING),
            },
        ),
        responses={200: "It will returns the user's login validity and other neccessary info",
                   400: "invalid login status returned"},
        security=[]

    )


def blog_post():
    return swagger_auto_schema(
        operation_description="This return the details of blog with the bid",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['bid'],
            properties={
                'bid': openapi.Schema(type=openapi.TYPE_STRING),
            },
        ),
        responses={200: "It will return the details",
                   400: "blog fetch failed"},
        security=[]

    )


def deposit_post_doc():
    return swagger_auto_schema(
        operation_description="Payment endpoint",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['reference_id'],
            properties={
                'reference_id': openapi.Schema(type=openapi.TYPE_STRING),
            },
        ),
        responses={
            200: "Payment Successfully, user is redirected to portal page"},
        security=[]

    )


def dashboard_doc():
    return swagger_auto_schema(
        operation_description="Dashboard post endpoint for saving blogs which requires the user to be logged in ",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['bid'],
            properties={
                'bid': openapi.Schema(type=openapi.TYPE_STRING),
            },
        ),
        responses={
            200: "Returns users details as described in the description above"},
        security=[]

    )


def postpone_course_doc():
    return swagger_auto_schema(
        operation_description="Certificate download endpoint which makes it easy for user to download certificate ",
        methods=['POST', "DELETE", "PUT"],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['reg_id'],
            properties={
                'reg_id': openapi.Schema(type=openapi.TYPE_STRING),
            },
        ),
        responses={
            200: "Course Posponed Successfully \
                \nCourse Deleted Successfully \nCourse Activated Successfully",
            400: "No registered user with the given reg_id \
                 \nCourse can't be posponed again \nCourse can still be taken or activated because it's still on \
                \nNo deletion done \nContact admin for activation"},

        security=[]

    )


def download_certificate_doc():
    return swagger_auto_schema(
        operation_description="Certificate download endpoint which makes it easy for user to download certificate ",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['reg_id'],
            properties={
                'reg_id': openapi.Schema(type=openapi.TYPE_STRING),
            },
        ),
        responses={
            200: "Returns the certificate for the course registered",
            400: "reg_id not found \nNo registration found with the reg_id given \nCerficate file not found"},

        security=[]

    )


def register_certificate_doc():
    return swagger_auto_schema(
        operation_description="Admin register certificate through this endpoint by supplying the values specified ",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['reg_id', 'certificate_file', 'completed'],
            properties={
                'reg_id': openapi.Schema(type=openapi.TYPE_STRING),
                "certificate_file": openapi.Schema(type=openapi.TYPE_FILE),
                "completed": openapi.Schema(type=openapi.TYPE_BOOLEAN)
            },
        ),
        responses={
            200: "file saved successfully",
            400: "You can't upload certificate \nreg_id or certifatce file \ncompleted filed missing"},

        security=[]

    )


def attendance_doc():
    return swagger_auto_schema(
        operation_description="Admin can make registration for candidates after a webinar",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['reg_id'],
            properties={
                'reg_id': openapi.Schema(type=openapi.TYPE_STRING),
            },
        ),
        responses={
            200: "Attendance marked successfully",
            400: "reg_id not seen \nNo registration found with the give id"},

        security=[]

    )


def download_report():
    return swagger_auto_schema(
        operation_description="Project report download endpoint",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['prid'],
            properties={
                'prid': openapi.Schema(type=openapi.TYPE_STRING),
            },
        ),
        responses={
            200: "Start download of the requested file"},
        security=[]

    )


def single_course_doc():
    return swagger_auto_schema(
        operation_description="This takes the course cid as parameter and gives the neccessary details about the course with the title provided ",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['cid'],
            properties={
                'cid': openapi.Schema(type=openapi.TYPE_STRING),
                
            },
        ),
        responses={
            200: "Returns course details in full"},
        security=[]

    )

def allCourseList_doc():
    return swagger_auto_schema(
        operation_description="This takes the course page(1,2,...) and course-tab(free,webinar,premium) as optional parameter and gives the neccessary details about the courses with the title provided ",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=[],
            properties={
                'page': openapi.Schema(type=openapi.TYPE_STRING),
                "course_tab":openapi.Schema(type=openapi.TYPE_STRING),
            },
        ),
        responses={
            200: "Returns list of courses  with the given course_tab or webinar courses by default if no course_tab given"},
        security=[]

    )

def ads_post_doc():
    return swagger_auto_schema(
        operation_description="",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['page'],
            properties={
                'page': openapi.Schema(type=openapi.TYPE_STRING),
            },
        ),
        responses={200: "It will return the details",
                   400: "course fetch failed"},
        security=[]

    )

def blog_post_doc():
    return swagger_auto_schema(
        operation_description="This gives decription about the blog listing api",
        methods=['POST'],
        request_body=openapi.Schema(
            type=openapi.TYPE_OBJECT,
            required=['page'],
            properties={
                'page': openapi.Schema(type=openapi.TYPE_STRING),
            },
        ),
        responses={200: "It will return the details",
                   400: "blogs fetch failed"},
        security=[]

    )