from unicodedata import category
from rest_framework import serializers
from .models import (
    User,
    course_registred_user,
    Author,
    extra_participant,
    project,
    project_batch,
    blogs,
    project_submission,
    Ads
)
from .course_models import Courses, Filter, Sort, course_audience, course_prerequesites, Video, FilterCategory
from django.utils.translation import gettext as _
from .check_number import number_check
import uuid
from django.http import JsonResponse


class SortSerializer(serializers.ModelSerializer):
    class Meta:
        model = Sort
        fields = ["label", "value"]

class FilterCategorySerializer(serializers.ModelSerializer):
    class Meta:
        model = FilterCategory
        fields = ["name"]

class FilterSerializer(serializers.ModelSerializer):
    
    class Meta:
        model = FilterCategory
        fields = ["name"]

    def to_representation(self, instance):
        representation = super().to_representation(instance)
        # print(representation)
        representation.pop("name")
        all_values = Filter.objects.filter(category = instance)
        representation[instance.name] = all_values.values("label", "value")
        return representation

class AdsSerializer(serializers.ModelSerializer):
    class Meta:
        model = Ads
        fields = ['code', 'page']


class RegistrationSerializer(serializers.ModelSerializer):
    user_status = serializers.CharField(max_length=100, required=False)

    class Meta:
        model = User
        fields = [
            "first_name",
            "last_name",
            "middle_name",
            "phone_number",
            "email",
            "password",
            "user_status",
        ]

    def save(self):
        """This method is being called because there are fields that can come as empty fields or not even present
        but we have included it as part of the fileds to be used by the serializer. Also there are checks to be done on some fields
        like phone_number and password to ensure that meet the laid down critaria
        """
        account = User(
            email=self.validated_data["email"],
            first_name=self.validated_data["first_name"],
            last_name=self.validated_data["last_name"],
        )

        # Since middle name can be optional
        try:
            middle_name = self.validated_data["middle_name"]
            if middle_name:
                account.middle_name = middle_name
        except:
            pass

        try:
            phone_number = self.validated_data["phone_number"]
            # check for the number validity
            result = number_check(phone_number)

            # check for phone number existence in the database
            if User.objects.filter(phone_number=phone_number).exists():
                raise serializers.ValidationError(
                    {"phone_number": "Phone number already exist"}
                )
            else:
                account.phone_number = phone_number

        except Exception as e:
            pass

        password = self.validated_data["password"]

        if len(password) < 8:
            raise serializers.ValidationError(
                {"password": "Password must be 8 characters long"}
            )
        elif password.isnumeric() or password.isalpha():
            raise serializers.ValidationError(
                {"password": "Password should contains both numbers and letters"}
            )

        account.set_password(password)
        account.username = account.email

        # Confirm the user validity by setting activeness to false which will be turned on on email confirmation
        account.is_verified = False

        account.save()

        return account


class LoginSerializer(serializers.Serializer):
    email = serializers.CharField(required=True, max_length=300)
    password = serializers.CharField(max_length=300)


class course_registred_userSerializer(serializers.ModelSerializer):
    class Meta:
        model = course_registred_user
        fields = [
            "first_name",
            "middle_name",
            "last_name",
            "company_institution",
            "phone_number",
            "email",
            "zip_number",
            "professional_academic_field",
            "address",
            "country",
            "number_of_slots",
        ]

    def save(self):
        course_user = course_registred_user(
            first_name=self.validated_data["first_name"],
            last_name=self.validated_data["last_name"],
            email=self.validated_data["email"],
            company_institution=self.validated_data["company_institution"],
            professional_academic_field=self.validated_data[
                "professional_academic_field"
            ],
            country=self.validated_data["country"],
            number_of_slots=self.validated_data["number_of_slots"],
        )

        # Handle optional fields if present
        try:
            zip_number = self.validated_data["zip_number"]
            if zip_number:
                course_user.zip_number = zip_number
        except:
            pass

        try:
            middle_name = self.validated_data["middle_name"]
            course_user.middle_name = middle_name
        except:
            pass
        try:
            address = self.validated_data["address"]
            course_user.address = address
        except:
            pass
        try:
            # check for the number validity
            phone_number = self.validated_data["phone_number"]
            result = number_check(phone_number)
            if result:
                course_user.phone_number = phone_number
        except:
            pass

        course_user.reference_id = uuid.uuid4().hex
        course_user.save()

        return course_user


class ExtraparticipantSerializer(serializers.ModelSerializer):
    class Meta:
        model = extra_participant
        fields = ["first_name", "middle_name", "last_name", "email"]


class UserSerializer(serializers.ModelSerializer):
    class Meta:
        model = User
        fields = [
            "id",
            "first_name",
            "last_name",
            "middle_name",
            "phone_number",
            "email",
        ]


class audienceserializer(serializers.ModelSerializer):
    class Meta:
        model = course_audience
        fields = ["audience"]


class course_prerequesitesserializer(serializers.ModelSerializer):
    class Meta:
        model = course_prerequesites
        fields = ["prerequesite"]


class videoSerializer(serializers.ModelSerializer):
    class Meta:
        model = Video
        fields = ["video_type", "video_file"]


class singlecourseSerializer(serializers.ModelSerializer):
    # audience = serializers.SerializerMethodField()
    class Meta:
        model = Courses
        fields = [
            "title",
            "course_tab",
            "category",
            "video_link",
            "overview",
            "venue",
            "training_software",
            "meta_tag",
            "active_course",
            "cid",
            'thubmnail',
            "sm_thubmnail"
        ]

    # def get_audience(self, obj):

    #     return obj.audience.all().values()


class courseSerializer(serializers.ModelSerializer):
    class Meta:
        model = Courses
        fields = [
            "title",
            "course_tab",
            "image",
            "category",
            "duration",
            "number_of_days",
            "price",
            "rating_star",
            "rating_number",
            "cid",
            "last_updated",
            "date_created"
        ]


class courseListSerializer(serializers.ModelSerializer):
    class Meta:
        model = Courses
        fields = [
            "course_tab",
            "title",
            "cid",
        ]

    def to_representation(self, instance):
        representation = super().to_representation(instance)
        video = Video.objects.filter(course=instance).first()
        if video:
            representation["duration"] = video.duration
        else:
            representation["duration"] = ""
        return representation


class coursescheduleSerializer(serializers.ModelSerializer):
    class Meta:
        model = Courses
        fields = [
            "title",
            "category",
            "duration",
            "number_of_days",
            "price",
            "course_start_date",
            "course_end_date",
            "active_course",
            "cid",
        ]


class courseinfoeSerializer(serializers.ModelSerializer):
    class Meta:
        model = Courses
        fields = [
            "title",
            "category",
            "course_start_date",
            "course_end_date",
            "time",
            "price",
        ]


class projectSerializer(serializers.ModelSerializer):
    class Meta:
        model = project_submission
        fields = [
            "project_title",
            "first_name",
            "middle_name",
            "last_name",
            "company_university",
            "phone_number",
            "email",
            "zip_number",
            "professional_academic_field",
            "address",
            "country",
            "project_nature",
            "project_file",
            "comment",
            "project_type",
        ]

    def save(self):
        project_save = project_submission(
            project_title=self.validated_data["project_title"],
            first_name=self.validated_data["first_name"],
            last_name=self.validated_data["last_name"],
            company_university=self.validated_data["company_university"],
            phone_number=self.validated_data["phone_number"],
            email=self.validated_data["email"],
            professional_academic_field=self.validated_data[
                "professional_academic_field"
            ],
            country=self.validated_data["country"],
            project_nature=self.validated_data["project_nature"]
        )

        try:
            middle_name = self.validated_data["middle_name"]
            if middle_name:
                project_save.middle_name = middle_name
        except:
            pass
        
        try:
            project_type = self.validated_data["project_type"]
            if project_type:
                project_save.project_type = project_type
        except:
            pass

        try:
            project_file = self.validated_data["project_file"]
            if project_file:
                project_save.project_file = project_file
        except:
            pass

        try:
            zip_number = self.validated_data["zip_number"]
            if zip_number:
                project_save.zip_number = zip_number
        except:
            pass

        try:
            address = self.validated_data["address"]
            if address:
                project_save.address = address
        except:
            pass

        try:
            comment = self.validated_data["comment"]
            if comment:
                project_save.comment = comment
        except:
            pass

        pre = "NPS"
        batch_number = project_batch.objects.all().order_by(
            "-pk")[0].batch_number
        sub_num = project_batch.objects.all().order_by(
            "-pk")[0].submission_number + 1
        if len(str(sub_num)) == 1:
            sub_num = "00" + str(sub_num)
        elif len(str(sub_num)) == 2:
            sub_num = "0" + str(sub_num)
        project_num = pre + str(batch_number) + str(sub_num)
        project_save.project_id = project_num
        # project_save.save()

        update = project_batch.objects.all().order_by("-pk")[0]
        update.submission_number += 1
        update.save()

        return project_save


class executed_projectSerializer(serializers.ModelSerializer):
    class Meta:
        model = project
        fields = [
            "image",
            "project_title",
            "country",
            "project_type",
            "project_scope",
            "project_duration",
            "project_completion_date",
            "prid",
        ]


class detail_projectSerializer(serializers.ModelSerializer):
    class Meta:
        model = project
        fields = [
            "detail_image",
            "project_title",
            "project_full_name",
            "country",
            "project_type",
            "project_nature",
            "project_scope",
            "project_duration",
            "project_completion_date",
            "prid",
            "meta",
        ]


# Password reset


class PasswordResetSerializer(serializers.Serializer):
    new_password = serializers.CharField(required=True)
    confirm_new_password = serializers.CharField(required=True)


class AuthorSerializer(serializers.ModelSerializer):
    class Meta:
        model = Author
        fields = ["name", "image"]

    def to_representation(self, instance):
        representation = super().to_representation(instance)
        representation["author_meta"] = {
            "author_img": instance.image.url,
            "author_img_alt": f"{instance.name} image",
            "author_desc": instance.about}
        return representation


class blogSerializer(serializers.ModelSerializer):
    class Meta:
        model = blogs
        fields = ["id", "title", "image", "content",
                  "read_time", "views"]

    def to_representation(self, instance):
        representation = super().to_representation(instance)
        representation['last_updated'] = instance.last_updated.strftime(
            "%B %d, %Y")
        representation["post_meta"] = {
            "author_name":  [author['name'] for author in instance.author.values("name")],
            "datetime": instance.date_published,
            "date": instance.date_published.strftime("%B %d, %Y")}
        return representation


class RecommendedBlogSerializer(serializers.ModelSerializer):
    class Meta:
        model = blogs
        fields = ["id", "title"]


class MoreBlogSerializer(serializers.ModelSerializer):
    class Meta:
        model = blogs
        fields = ["id", "title", "image"]

    def to_representation(self, instance):
        representation = super().to_representation(instance)
        representation["post_meta"] = {
            "author_name":  [author['name'] for author in instance.author.values("name")],
            "img_alt": "author image",
            "datetime": instance.date_published,
            "date": instance.date_published.strftime("%B %d, %Y")}
        return representation


class blog_detailSerializer(serializers.ModelSerializer):
    author = AuthorSerializer(many=True)

    class Meta:
        model = blogs
        fields = ["title", "image", "full_content", "meta",
                  "author", "bid", "read_time", "views"]

    def to_representation(self, instance):
        representation = super().to_representation(instance)
        representation['last_updated'] = instance.last_updated.strftime(
            "%B %d, %Y")
        representation["post_meta"] = {
            "author_name":  [author['name'] for author in instance.author.values("name")],
            "datetime": instance.date_published,
            "date": instance.date_published.strftime("%B %d, %Y")}
        return representation


class ImageSerializer(serializers.ModelSerializer):
    class Meta:
        model = User
        fields = ["first_name", "image", "last_name", "email"]


class prmiumlinkSerialiser(serializers.ModelSerializer):
    class Meta:
        model = Courses
        fields = ['cid', 'video_link', 'course_tab']
