import os
import requests
import json
from django.utils import timezone
from .serializer import singlecourseSerializer
from django.core.paginator import Paginator, EmptyPage
from rest_framework.response import Response
from rest_framework import status
from rest_framework import serializers
from .models import extra_participant


def single_web_response(course_gotten, prev_course, next_course):
    if (
        course_gotten.active_course
        and course_gotten.reg_end_date.date() < timezone.now().date()
    ):
        course_gotten.active_course = False
        course_gotten.save()
    # audience and prerequisite query needs to be refactored
    audience = [entry.audience for entry in course_gotten.course_audience_set.all()]
    prerequesite = [
        entry.prerequesite for entry in course_gotten.course_prerequesites_set.all()]
    if not prerequesite:
        prerequesite = ["None"]
    objectives = [
        entry.objective for entry in course_gotten.objectives_set.all()]

    serializer = singlecourseSerializer(course_gotten)
    response = {}
    response.update(serializer.data)
    data = {
        "objectives": objectives,
        "audience": audience,
        "prerequisites": prerequesite,
        "pid": "single-course",
        "prev_course": prev_course,
        "next_course": next_course,
    }
    response.update(data)
    return response


def paginate(courses, page_number, serializer, model="courses"):
    paginator = Paginator(courses, 9)
    pagination_result = paginator.get_page(page_number)
    data_serializer = serializer(pagination_result.object_list, many=True)
    return {
        "total_pages": paginator.num_pages,
        "current_page": pagination_result.number,
        "courses" if model == "courses" else "blogs": data_serializer.data,
    }


def password_validator(user, new_password, confirm_new_password):
    if len(new_password) < 8:
        raise serializers.ValidationError(
            {"password": "Password must be 8 characters long"}
        )
    elif new_password.isnumeric() or new_password.isalpha():
        raise serializers.ValidationError(
            {"password": "Password should contains both numbers and letters"}
        )
    elif new_password != confirm_new_password:
        raise serializers.ValidationError(
            {"password": "Passwords do not match"})
    else:
        user.set_password(new_password)
        user.save()
        return Response(
            {"Success": "Password reset successfully"},
            status=status.HTTP_200_OK,
        )


def save_other_participants(request, course_user, number_of_slots):
    for i in range(2, int(number_of_slots) + 1):
        save_extra_participant = extra_participant.objects.create(
            first_name=request.data["first_name_" + str(i)],
            last_name=request.data["last_name_" + str(i)],
            middle_name=request.data.get("middle_name_" + str(i), " "),
            email=request.data["email_" + str(i)],
            registra=course_user,
            course=course_user.course
        )

    return "Done"
