from pytz import timezone
from .models import course_registred_user, payment, Subscription, paypal_access
import uuid
import os
from rest_framework.response import Response
from .course import get_reg_id
from django.shortcuts import redirect
from requests.auth import HTTPBasicAuth
import requests
import json


def deposit(ref_id):

    course_object = course_registred_user.objects.get(reference_id=ref_id)
    user = course_object.user
    slot_number = course_object.number_of_slots
    amount = course_object.course.price * slot_number #* int(os.environ.get("rate"))
    email = user.email
    # charge = (0.018 * float(amount)) + float(amount)
    amount = int(amount * 100)  # convert the money to kobo

    # Generate another reference id to prevent the one coming from front end in case of being tempered with
    user_reference_number = str(uuid.uuid4().hex)
    del_like_payment = payment.objects.filter(user=user, status="pending")
    del_like_payment.delete()
    user_payment = payment.objects.create(
        user=user,
        amount=amount / 100,
        status="pending",
        reference_number=user_reference_number,
        payment_for="course"
    )

    # Attach the reference number to the user account
    course_object.payment_reference_id = user_reference_number
    course_object.save()

    key = os.environ.get("key")
    name = user.get_full_name()

    return name, email, amount, key, user_reference_number


def run_work(reference_number_recieved):
    try:
        course_object = course_registred_user.objects.filter(
            payment_reference_id=reference_number_recieved, paid=False
        ).first()
        if course_object:
            user_pending_payment = payment.objects.get(
                reference_number=course_object.payment_reference_id, status="pending"
            )

            """Mark the user as paid and generate registration id for the user"""
            user_pending_payment.status = "Completed"
            user_pending_payment.save()
            course_object.paid = True
            course_object.pay_later = False
            result = get_reg_id(course_object)
            # redirect to the page to show payment is confirmed
            # return Response({"response": "Payment confirmed successfull"}, status=status.HTTP_200_OK)
            return redirect(
                "https://nubyira.com/pages/learn.html?payment_status=success"
            )
    except course_registred_user.DoesNotExist:
        # Redirect user to course registration page
        return Response({"response": "User making payment is not registered"})


def subscribed(reference_number):
    get_payment = payment.objects.filter(
        reference_number=reference_number).first()
    get_payment.satatus = "Completed"
    get_payment.save()

    # create the subcription object if it does not exist and update the subscribed field
    if get_payment.payment_for == 'subscription':
        create_subscribed_user, created = Subscription.objects.get_or_create(
            user=get_payment.user, subscribed=True, last_sub_date= timezone.now
        )
    return redirect(f"https://nubyira.com/pages/dashboard.html")


def get_access_token():
    current_token = paypal_access.objects.all().first()
    if current_token:
        created_at, expires_in = current_token.created_at, current_token.expires_in
    if expires_in < int(created_at.strftime("%Y%m%d%H%M%S")):
        url = os.environ.get("paypal_access_url")
        auth = HTTPBasicAuth(
            os.environ.get("paypal_client_id"), os.environ.get(
                "paypal_secret_id")
        )
        data = {"grant_type": "client_credentials"}
        response = requests.request("POST", url, auth=auth, data=data)
        response = json.loads(response.text)
        if response:
            if current_token:
                current_token.delete()
            current_token = paypal_access.objects.create(
                token=response["access_token"], expires_in=response["expires_in"]
            )
            return response["access_token"]
    else:
        access_token = current_token.token
        return access_token


def confirm_paystack_payment(request):

    ref_id = request.GET.get("ref_id")
    prid = request.GET.get("prid")
    cid = request.GET.get("cid")
    if not ref_id:
        return Response({"ref_id": "ref_id not seen"})
    # elif not cid or prid:
    #     return Response({"cid_or_prid": "cid or prid not seen"})
    url = f"https://api.paystack.co/transaction/verify/{ref_id}"
    # os.environ.get("sk_key")
    sk_key = os.environ.get(
        "sk_key")
    headers = {"Authorization": f"Bearer {sk_key}"}

    response = requests.request("GET", url, headers=headers)
    response = json.loads(response.text)
    if response.get("data"):
        if response["data"]["status"] == "success":
            returned_reference = response["data"]["reference"]
            status = request.GET.get("status")
            if status == "subscription":
                return subscribed(returned_reference)
            # elif status == "subscription" and cid:
            #     return subscribed(returned_reference, cid)
            else:
                return run_work(returned_reference)
        else:
            user_payment = payment.objects.filter(reference_number=ref_id)
            user_payment.delete()
            # redirection should be to the paymnet page
            return redirect("https://nubyira.com/pages/dashboard.html?payment_status=abandoned")
    return Response({"error": response})
