from django.core.paginator import Paginator, EmptyPage
from .course_models import Courses
from .models import blogs


# class PrevNext:

#     def __init__(self, db_obj, state) -> None:
#         self.db_obj = db_obj
#         self.state = state

#     def get_available_courses(self):
#         if self.state == "course":
#             db = (
#                 Courses.objects.filter(
#                     course_tab=self.db_obj.course_tab, active_course = True
#                 ).order_by("category", "title")
#                 # .exclude(cid=db_obj.cid)
#             )
#         else:
#             db = blogs.objects.order_by("date_published", "title")
#         return db

#     def get_paginated_result(self):
#         current_page = Paginator(self.get_available_courses(), 1)
#         page_obj = current_page.page(1)
#         return

def prev_next(db_obj, state):
    if state == "course":
        # Get the list of courses
        db = (
            Courses.objects.filter(course_tab=db_obj.course_tab,
                                   active_course=True).order_by("category", "title")
            # .exclude(cid=db_obj.cid)
        )

    elif state == "blog":
        # Get the list of courses
        db = blogs.objects.order_by("date_published", "title")
        # Break the pages into one course per page
    current_page = Paginator(db, 1)
    # Loop through the all pages
    for page_number in range(1, current_page.num_pages + 1):
        # Get each page
        page_obj = current_page.page(page_number)
        # Loop through the page i.e get the course
        for entry in page_obj:

            # check if entry is equal to the course coming from front end
            if entry == db_obj:
                # Check if the current page has next page
                if page_obj.has_next:
                    # Get the page to get the course on the page

                    try:
                        next_page = current_page.page(
                            page_obj.next_page_number())
                        for obj in next_page:
                            if state == "course":
                                next_obj = obj.cid
                            elif state == "blog":
                                next_obj = {"bid": obj.pk, "title": obj.title}
                    except EmptyPage:
                        next_obj = "None"

                else:
                    next_obj = "None"
                if page_obj.has_previous:
                    # Get the page to get the course on the page
                    try:
                        prev_page = current_page.page(
                            page_obj.previous_page_number())
                        for obj in prev_page:
                            if state == "course":
                                prev_obj = obj.cid
                            elif state == "blog":
                                prev_obj = {"bid": obj.pk, "title": obj.title}
                    except EmptyPage:
                        prev_obj = "None"

                else:
                    prev_obj = "None"

                return prev_obj, next_obj
    else:
        if not db:
            return "None", "None"
        return prev_next(db.first(), "course")
