# Generated by Django 4.2.13 on 2024-07-08 20:28

import ckeditor_uploader.fields
from django.conf import settings
import django.contrib.auth.models
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import django_resized.forms
import taggit.managers


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
        ('taggit', '0006_rename_taggeditem_content_type_object_id_taggit_tagg_content_8fc721_idx'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('first_name', models.CharField(max_length=100)),
                ('middle_name', models.CharField(blank=True, max_length=100)),
                ('last_name', models.CharField(max_length=100)),
                ('phone_number', models.CharField(max_length=30)),
                ('email', models.EmailField(max_length=254, unique=True)),
                ('password', models.CharField(max_length=100)),
                ('date_joined', models.DateTimeField(blank=True, default=django.utils.timezone.now)),
                ('username', models.CharField(blank=True, max_length=100)),
                ('is_verified', models.BooleanField(default=False)),
                ('image', models.ImageField(blank=True, null=True, upload_to='user_image')),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.permission', verbose_name='user permissions')),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
                'abstract': False,
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='Ads',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.TextField()),
                ('page', models.CharField(default='blog', max_length=50, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Author',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=200)),
                ('image', django_resized.forms.ResizedImageField(blank=True, crop=None, force_format=None, keep_meta=True, quality=-1, scale=None, size=[300, 300], upload_to='author')),
                ('about', models.TextField(blank=True)),
            ],
        ),
        migrations.CreateModel(
            name='blogs',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.TextField(blank=True)),
                ('date_published', models.DateField(blank=True, default=django.utils.timezone.now)),
                ('date_created', models.DateField(blank=True, default=django.utils.timezone.now)),
                ('image', django_resized.forms.ResizedImageField(blank=True, crop=None, force_format='PNG', keep_meta=True, null=True, quality=-1, scale=None, size=[500, 500], upload_to='article_pics')),
                ('content', ckeditor_uploader.fields.RichTextUploadingField(blank=True)),
                ('full_content', ckeditor_uploader.fields.RichTextUploadingField(blank=True)),
                ('status', models.CharField(choices=[('Drafted', 'Drafted'), ('Published', 'Published')], default='DRAFT', max_length=20)),
                ('views', models.PositiveIntegerField(default=0)),
                ('count_words', models.CharField(blank=True, default=0, max_length=500)),
                ('read_time', models.CharField(blank=True, default=0, max_length=500)),
                ('deleted', models.BooleanField(blank=True, default=False)),
                ('bid', models.CharField(blank=True, max_length=10)),
                ('meta', models.TextField(blank=True)),
                ('last_updated', models.DateField(default=django.utils.timezone.now)),
                ('author', models.ManyToManyField(blank=True, to='api.author')),
                ('tags', taggit.managers.TaggableManager(blank=True, help_text='A comma-separated list of tags.', through='taggit.TaggedItem', to='taggit.Tag', verbose_name='Tags')),
            ],
            options={
                'verbose_name_plural': 'blogs',
                'ordering': ('-date_published',),
            },
        ),
        migrations.CreateModel(
            name='course_audience',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('audience', models.CharField(blank=True, max_length=300, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='course_prerequesites',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('prerequesite', models.CharField(blank=True, max_length=300, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='course_registred_user',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=100)),
                ('middle_name', models.CharField(blank=True, max_length=100)),
                ('last_name', models.CharField(max_length=100)),
                ('company_institution', models.CharField(max_length=500)),
                ('phone_number', models.CharField(blank=True, max_length=30)),
                ('email', models.EmailField(max_length=254)),
                ('zip_number', models.CharField(blank=True, max_length=100)),
                ('professional_academic_field', models.CharField(max_length=500)),
                ('address', models.CharField(blank=True, max_length=500)),
                ('country', models.CharField(max_length=500)),
                ('number_of_slots', models.PositiveIntegerField(default=1)),
                ('reference_id', models.UUIDField(blank=True)),
                ('payment_reference_id', models.UUIDField(blank=True, null=True)),
                ('paid', models.BooleanField(default=False)),
                ('pay_later', models.BooleanField(default=True)),
                ('batch_no', models.CharField(blank=True, max_length=5, null=True)),
                ('registration_id', models.CharField(blank=True, max_length=30)),
                ('date_registered', models.DateTimeField(blank=True, default=django.utils.timezone.now)),
                ('completed', models.BooleanField(default=False)),
                ('postponed', models.BooleanField(default=False)),
                ('archived', models.BooleanField(default=False)),
                ('start_date', models.DateField(blank=True, null=True)),
                ('end_date', models.DateField(blank=True, null=True)),
                ('certificate', models.BooleanField(default=False)),
                ('attendance', models.PositiveIntegerField(default=0)),
            ],
            options={
                'verbose_name_plural': 'Course Registerd Participants',
                'ordering': ['user', 'course'],
            },
        ),
        migrations.CreateModel(
            name='Courses',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=300)),
                ('course_tab', models.CharField(choices=[('Free', 'Free'), ('Webinar', 'Webinar'), ('Premium', 'Premium')], default='Webinar', max_length=20)),
                ('course_code', models.CharField(blank=True, max_length=10, null=True, unique=True)),
                ('image', django_resized.forms.ResizedImageField(blank=True, crop=None, force_format='PNG', keep_meta=True, quality=-1, scale=None, size=[3000, 1740], upload_to='course_pics')),
                ('thubmnail', models.ImageField(blank=True, null=True, upload_to='premium_thumnail')),
                ('sm_thubmnail', models.ImageField(blank=True, null=True, upload_to='premium_thumnail')),
                ('duration', models.PositiveIntegerField(blank=True, help_text='This is the number of hours per day for the course', null=True)),
                ('overview', models.TextField(blank=True)),
                ('course_start_date', models.DateField(blank=True, null=True)),
                ('course_end_date', models.DateField(blank=True, null=True)),
                ('number_of_days', models.PositiveIntegerField(blank=True, null=True)),
                ('price', models.PositiveIntegerField(blank=True, null=True)),
                ('venue', models.CharField(blank=True, max_length=200)),
                ('category', models.CharField(blank=True, choices=[('Basic Course', 'Basic Course'), ('Intermediate Course', 'Intermediate Course'), ('Professional Course', 'Professional Course')], max_length=250)),
                ('active_course', models.BooleanField(default=False)),
                ('reg_end_date', models.DateTimeField(blank=True, null=True)),
                ('rating_star', models.FloatField(default=0)),
                ('rating_number', models.IntegerField(default=0)),
                ('video_link', models.TextField(blank=True)),
                ('cid', models.CharField(blank=True, max_length=200)),
                ('training_software', models.CharField(blank=True, default='None', max_length=200, verbose_name='Training software')),
                ('meta_tag', models.TextField(blank=True)),
                ('files', models.FileField(blank=True, null=True, upload_to='course_files', validators=[django.core.validators.FileExtensionValidator(allowed_extensions=['pdf', 'zip'])])),
                ('time', models.CharField(default='01:00 - 03:00', max_length=30)),
                ('coupon_code', models.CharField(blank=True, max_length=200)),
                ('last_updated', models.DateTimeField(default=django.utils.timezone.now)),
                ('date_created', models.DateTimeField(default=django.utils.timezone.now)),
                ('audience', models.ManyToManyField(blank=True, to='api.course_audience')),
            ],
            options={
                'verbose_name_plural': 'Courses',
            },
        ),
        migrations.CreateModel(
            name='FilterCategory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='IpModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ip', models.CharField(max_length=150)),
            ],
        ),
        migrations.CreateModel(
            name='paypal_access',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('token', models.TextField()),
                ('expires_in', models.PositiveIntegerField()),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
            ],
            options={
                'verbose_name_plural': 'Paypal Access',
            },
        ),
        migrations.CreateModel(
            name='project',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('project_title', models.CharField(blank=True, max_length=400)),
                ('project_full_name', models.CharField(blank=True, max_length=600)),
                ('country', models.CharField(blank=True, max_length=500)),
                ('project_nature', models.CharField(choices=[('Full execution', 'Full execution'), ('Project assistance', 'Project assistance')], max_length=200)),
                ('project_type', models.TextField()),
                ('project_scope', models.CharField(blank=True, max_length=300)),
                ('executed', models.BooleanField(default=False)),
                ('image', models.ImageField(blank=True, upload_to='projects')),
                ('detail_image', models.ImageField(blank=True, upload_to='projects')),
                ('meta', models.TextField(blank=True)),
                ('project_duration', models.CharField(blank=True, max_length=100)),
                ('project_completion_date', models.CharField(blank=True, max_length=20, null=True)),
                ('prid', models.CharField(blank=True, max_length=100, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='project_batch',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('batch_number', models.CharField(max_length=10)),
                ('submission_number', models.PositiveIntegerField(default=0)),
                ('number_of_project_excuted', models.PositiveIntegerField(default=0)),
            ],
            options={
                'verbose_name_plural': 'Project Batches',
            },
        ),
        migrations.CreateModel(
            name='Sort',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.CharField(help_text='This is the name of the sort e.g name or date', max_length=200)),
                ('value', models.CharField(help_text='this is the sort value e.g a-z or z-a or newest-first or oldest-first', max_length=200)),
                ('on', models.BooleanField(default=False, help_text='This is to make it available to the front end or not')),
            ],
        ),
        migrations.CreateModel(
            name='Video',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('video_file', models.FileField(blank=True, upload_to='course videos')),
                ('video_link', models.URLField(blank=True)),
                ('duration', models.CharField(blank=True, max_length=10)),
                ('course', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='api.courses')),
            ],
        ),
        migrations.CreateModel(
            name='Subscription',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('subscribed', models.BooleanField(default=False)),
                ('date_created', models.DateTimeField(default=django.utils.timezone.now)),
                ('last_sub_date', models.DateTimeField(blank=True, help_text='This is to keep track of when a user subscribed', null=True)),
                ('max_number_of_days', models.PositiveIntegerField(default=31)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Subscriptions',
            },
        ),
        migrations.CreateModel(
            name='saved_blogs',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_saved', models.DateTimeField(default=django.utils.timezone.now)),
                ('blog', models.ManyToManyField(to='api.blogs')),
                ('user', models.ForeignKey(blank=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Saved Blogs',
            },
        ),
        migrations.CreateModel(
            name='review',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('rate', models.CharField(choices=[('1', '1'), ('2', '2'), ('3', '3'), ('4', '4'), ('5', '5')], max_length=5)),
                ('course', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='api.courses')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='project_submission',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('project_title', models.CharField(blank=True, max_length=400)),
                ('first_name', models.CharField(max_length=200)),
                ('middle_name', models.CharField(blank=True, max_length=200)),
                ('last_name', models.CharField(max_length=250)),
                ('company_university', models.CharField(max_length=300)),
                ('email', models.EmailField(max_length=254)),
                ('phone_number', models.CharField(max_length=30)),
                ('zip_number', models.CharField(blank=True, max_length=10)),
                ('professional_academic_field', models.CharField(max_length=500)),
                ('address', models.CharField(blank=True, max_length=500)),
                ('country', models.CharField(blank=True, max_length=500)),
                ('project_file', models.FileField(blank=True, null=True, upload_to='project_file')),
                ('comment', models.TextField(blank=True)),
                ('project_id', models.CharField(blank=True, max_length=100)),
                ('project_nature', models.CharField(choices=[('Full execution', 'Full execution'), ('Project assistance', 'Project assistance')], max_length=200)),
                ('project_type', models.TextField()),
                ('date_submitted', models.DateField(blank=True, default=django.utils.timezone.now, null=True)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Project Submissions',
            },
        ),
        migrations.CreateModel(
            name='Project_files',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('project_report', models.FileField(upload_to='project reports', validators=[django.core.validators.FileExtensionValidator(allowed_extensions=['pdf', 'zip'])])),
                ('useful_links', models.URLField(blank=True, null=True)),
                ('date_added', models.DateField(default=django.utils.timezone.now)),
                ('project_for', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='api.project')),
            ],
            options={
                'verbose_name_plural': 'Project Files',
            },
        ),
        migrations.CreateModel(
            name='payment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(default=django.utils.timezone.now)),
                ('reference_number', models.UUIDField()),
                ('amount', models.PositiveIntegerField()),
                ('status', models.CharField(max_length=50)),
                ('payment_for', models.CharField(blank=True, max_length=20)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='passwordresetcode',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=200)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('checked', models.BooleanField(default=False)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Passsword Reset',
            },
        ),
        migrations.CreateModel(
            name='objectives',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('objective', models.CharField(blank=True, max_length=600, null=True)),
                ('course', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='api.courses')),
            ],
        ),
        migrations.CreateModel(
            name='Filter',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.CharField(help_text='This is the name of the filter e.g category or field or tarining software', max_length=200)),
                ('value', models.CharField(help_text='This is the value of the filter e.g Basic', max_length=200)),
                ('on', models.BooleanField(default=False, help_text='This is to make it available to the front end or not')),
                ('category', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='api.filtercategory')),
            ],
        ),
        migrations.CreateModel(
            name='extra_participant',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=100)),
                ('middle_name', models.CharField(blank=True, max_length=100)),
                ('last_name', models.CharField(max_length=100)),
                ('email', models.EmailField(max_length=254)),
                ('course', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='api.courses')),
                ('registra', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='api.course_registred_user')),
            ],
            options={
                'verbose_name_plural': 'Extra Participant',
            },
        ),
        migrations.CreateModel(
            name='emailconfirmationcode',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=200)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Email Confirmation',
            },
        ),
        migrations.AddField(
            model_name='courses',
            name='course_objectives',
            field=models.ManyToManyField(blank=True, to='api.objectives'),
        ),
        migrations.AddField(
            model_name='courses',
            name='field_filter',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='api.filter'),
        ),
        migrations.AddField(
            model_name='courses',
            name='prerequisites',
            field=models.ManyToManyField(blank=True, to='api.course_prerequesites'),
        ),
        migrations.AddField(
            model_name='course_registred_user',
            name='course',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='api.courses'),
        ),
        migrations.AddField(
            model_name='course_registred_user',
            name='user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='user', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='course_prerequesites',
            name='course',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='api.courses'),
        ),
        migrations.CreateModel(
            name='course_certificate',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('certificate_file', models.FileField(upload_to='Certificates', validators=[django.core.validators.FileExtensionValidator(allowed_extensions=['pdf', 'zip', 'png', 'jpeg', 'jpg'])])),
                ('date_added', models.DateField(default=django.utils.timezone.now)),
                ('reg_obj', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='api.course_registred_user')),
            ],
            options={
                'ordering': ['reg_obj'],
            },
        ),
        migrations.CreateModel(
            name='course_batch',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('batch_number', models.CharField(max_length=10)),
                ('submission_number', models.PositiveIntegerField(default=0)),
                ('next_batch_date', models.DateField(blank=True, null=True)),
                ('next_batch_time', models.CharField(blank=True, max_length=30, null=True)),
                ('active', models.BooleanField(default=False)),
                ('course', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='api.courses')),
            ],
            options={
                'verbose_name_plural': 'course_batches',
            },
        ),
        migrations.AddField(
            model_name='course_audience',
            name='course',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='api.courses'),
        ),
        migrations.CreateModel(
            name='comment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content', models.TextField()),
                ('date_commented', models.DateTimeField(blank=True, default=django.utils.timezone.now)),
                ('reply', models.TextField(blank=True)),
                ('article', models.ForeignKey(blank=True, on_delete=django.db.models.deletion.CASCADE, to='api.blogs')),
                ('name', models.ForeignKey(blank=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='course_registered_user_proxy',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('api.course_registred_user',),
        ),
    ]
