from django import forms
from .models import blogs, project
from .course_models import Courses, Filter


class CertificateForm(forms.ModelForm):
    def clean(self):
        certificate_file = self.cleaned_data['certificate_file']
        reg_obj = self.cleaned_data['reg_obj']
        if certificate_file.name != "zip" and reg_obj.number_of_slots > 1:
            raise forms.ValidationError(
                {'certificate_file': "File should be zip of certificates since this user register for more than one users"})


class BlogForm(forms.ModelForm):
    class Meta:
        model = blogs
        fields = ['title', "author", "image", "status",
                  "content", "full_content", "meta"]


class WebCourseForm(forms.ModelForm):
    class Meta:
        model = Courses
        fields = ["title", "category", "course_tab", "image", "duration", "course_code",
                  "overview", "course_start_date", "course_end_date", "number_of_days",
                  "price", "venue", "active_course", "reg_end_date", "rating_star",
                  "rating_number", "video_link", "training_software", "meta_tag", "time"]


class FreeCourseForm(forms.ModelForm):
    class Meta:
        model = Courses
        fields = ["title", "course_tab", 'files',
                  "overview", "video_link", "training_software", "meta_tag"]


class projectForm(forms.ModelForm):

    class Meta:
        model = project
        exclude = ["prid", "image", "detail_image"]


class CourseForm(forms.ModelForm):
    class Meta:
        model = Courses
        fields = "__all__"

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        filed_options = Filter.objects.filter(category = "Course Field")
        # instance = kwargs.get("instance")
        # if instance:
        #     if instance.field:
        #         # if we're using this form to edit a post instance, we'll do this
        #         current_field = Filter.objects.filter(pk=instance.field.pk) 
        #         filed_options = ( filed_options | current_field ) # combine querysets
        # self.fields['field'].queryset  = filed_options
        # print(self.fields['field'].queryset)
        
        # pre-fill the timezone for good measure
        # self.fields['publish_date'].initial = timezone.now()