from email import message
from .models import emailconfirmationcode, extra_participant, passwordresetcode
from django.shortcuts import redirect
from django.utils.encoding import force_bytes
from django.utils.http import urlsafe_base64_encode
from django.contrib.auth.tokens import default_token_generator
from django.core.mail import BadHeaderError, send_mail
from .zepto import zeptomail



def account_confirmation(account, user_status):
    # Generate token and encode user primary key
    token = default_token_generator.make_token(account)
    uid = urlsafe_base64_encode(force_bytes(account.pk))

    # Delete any confirmation token attached to the user if exist
    get_email_confirms = emailconfirmationcode.objects.filter(user=account)
    get_email_confirms.delete()

    # store the generated token attached to the user's account in the emailconfirmation table
    email_code = emailconfirmationcode.objects.create(code=token, user=account)

    # Send the email
    subject = "Account Acctivation"
    url = f"https://api.nubyira.com/api/v1/activate/{user_status}/{uid}/{token}/"
    html_message = f"""<div style="margin: 5% 0%;">
                <div style="text-align: left;">
            <img src="https://public-files-paystack-prod.s3.eu-west-1.amazonaws.com/integration-logos/tcwylg78o6fihadfv982.png" width="100" >
            </div>

            <h2>Welcome to Nubyira Process Designer</h2>
            Hello {account.first_name}, <br><br>As a form of avoiding unrealistic,robot users and for security precautions,we have to ensure email confirmation.<br><br>
                Please click on the link below to confirm your registration, Just ignore if you did not sign up for Nubyira Process Designer<br><br><strong>Note: The link is only valid for 7 minutes and it can only be used once.</strong><br><br><a href=\"{url}\" style="color:white; text-decoration: none;border-radius: 25px; background-color: #754C28; padding: 7px 25px;"> <strong>Verify Email<strong></a>
                <br><br> Nubyira LTD (RC 1758884) is an online-based consulting and training company that specializes in process and
                plant design services. We provide process R&D, simulation, optimization, troubleshooting, safety analysis,
                engineering drafting & operation flowsheet, CAD modelling and plant rating services & training for process and allied
                industries to meet their economic demands and profitability.
            </div>"""
    email_content = ""

    try:
        zeptomail(account.email,f"{account.first_name} {account.last_name}", subject, html_message)

        # send_mail(
        #     subject,
        #     email_content,
        #     "admin@nubyira.com",
        #     [account.email],
        #     fail_silently=False,
        #     html_message=html_message,

        # )
        return "email sent successfully"
    except BadHeaderError:
        return "email not sent"


def password_reset_email(user):

    token = default_token_generator.make_token(user)
    uid = urlsafe_base64_encode(force_bytes(user.pk))

    # Delete any password code attached to the user if there is any
    password_token = passwordresetcode.objects.filter(user=user)
    password_token.delete()

    # Create new password reset token
    stored_token = passwordresetcode.objects.create(code=token, user=user)

    html_message = f"""<div style="margin: 5% 0%;">
                <div style="text-align: left;">
            <img src="https://public-files-paystack-prod.s3.eu-west-1.amazonaws.com/integration-logos/tcwylg78o6fihadfv982.png" width="100" >
            </div>

            <h2>Reset Your Password</h2>
            Hello {user.first_name}, <br><br>Someone requested for password reset link for an account associated with this email.<br><br>
                Click on the link below to reset your password, Just ignore if you did not request for the link<br><br><strong>Note: The link is only valid for 7 minutes and it can only be used once.</strong><br><br><a href=\"https://api.nubyira.com/api/v1/reset/{uid}/{token}\" style="color:white; text-decoration: none;border-radius: 25px; background-color: #754C28; padding: 7px 25px;"> <strong>Reset Password<strong></a>
            </div>"""
    subject = "Password Reset link"

    email = ""
    try:
        zeptomail(user.email,f"{user.first_name} {user.last_name}", subject, html_message)
        # send_mail(
        #     subject,
        #     email,
        #     "admin@nubyira.com",
        #     [user.email],
        #     fail_silently=False,
        #     html_message=html_message,
        # )
        return "email sent successfully"
    except BadHeaderError:
        pass


def course_email(course_object, reg_id):
    course = str(course_object.course.title)

    # <div>Download the course materials <a href=#>here</a> to prepare for the course.</div>
    html_message = f"""
        <div>Thank you for registering for our exclusive {course} webinar which runs from
        <strong>{course_object.course.course_start_date} to {course_object.course.course_end_date}</strong>
        <strong>The webinar runs each day at {course_object.course.time} GMT:00 timezone </strong><br><br>
        </div>
        <div>Your registration ID is <span id="reg-id">{reg_id}</span></div>
        <div>The course webinar meeting channel is <span id="reg-id">{course_object.course.venue}</span></div>
        <div>The course webinar meeting ID is <span id="reg-id">..........</span></div>
        <div>On the webinar date you can join the webinar through this link https://youtu.be/lcitEc1yiMo </div>
        <div>The email addresses of all participants will be given automatic approval to join the course webinar whenever it goes live</div>

        <div>Once completed, check your dashboard to print your certificate and that of the additional participants you registered</div>
        <div>Thank you</div>
        <div class="contact">
          <div>For enquires and complaints
          </div>
          <div>admin@nubyira.com</div>
        </div>
      </div>"""

    subject = "Webinar Registration Information"
    extra_mail = extra_participant.objects.filter(registra=course_object)
    if extra_mail:
        mail_list = [str(course_object.email)] + [str(i.email)
                                                  for i in extra_mail]
    else:
        mail_list = [course_object.email]

    email_content = ""
    try:
        for email in mail_list:
            zeptomail(email,"participant", subject, html_message)
        # send_mail(
        #     subject,
        #     email_content,
        #     "admin@nubyira.com",
        #     mail_list,
        #     fail_silently=False,
        #     html_message=html_message,
        # )
        return "email sent successfully"
    except BadHeaderError:
        pass


def project_email(project_save):

    html_message = f"""<div style="margin: 5% 0%;">
                <div style="text-align: left;">
                    <img src="https://public-files-paystack-prod.s3.eu-west-1.amazonaws.com/integration-logos/tcwylg78o6fihadfv982.png" width="100" >
                    </div>

                    <h2>Project Submission Response</h2>
                    Hello, You have successfully submitted to Nubyira project submission, We will get in touch with you the next working day
                    the submission was made.<br><br>
                    Your project identification number: {project_save.project_id}
                    If you have additional information regarding the project, simply reply to this email and we will treat it as urgent.
                    <br><br>
                    Thank you for choosing Nubyira.
                </div>"""
    subject = "Project Submission Confirmed"

    email_content = ""
    try:
        zeptomail(project_save.email,"participant", subject, html_message)
        # send_mail(
        #     subject,
        #     email_content,
        #     "admin@nubyira.com",
        #     [project_save.email],
        #     fail_silently=False,
        #     html_message=html_message,
        # )

        return "email sent successfully"
    except BadHeaderError:
        pass


def project_email_admin(project_save):

    html_message = f"""<div style="margin: 5% 0%;">
                <div style="text-align: left;">
                    <img src="https://public-files-paystack-prod.s3.eu-west-1.amazonaws.com/integration-logos/tcwylg78o6fihadfv982.png" width="100" >
                    </div>

                    <h2>Project Submission Alert</h2>
                    A new project work has just been submmitted by {project_save.user}.<br><br>
                    The project identification number is: {project_save.project_id}
                    <br><br>
                    Go to the admin dashboard to view the details of the project.
                </div>"""
    subject = "Project Submission Alert"

    email_content = ""
    try:
        zeptomail("projects@nubyira.com","Nubyira Projects", subject, html_message)
        # send_mail(
        #     subject,
        #     email_content,
        #     "admin@nubyira.com",
        #     ["projects@nubyira.com"],
        #     fail_silently=False,
        #     html_message=html_message,
        # )

        return "email sent successfully"
    except BadHeaderError:
        pass


def email_user(email, subject, message):

    html_message = f"""<div style="margin: 5% 0%;">

                    <h2>Message from Nubyira Process Designer Admin</h2>
                   {message}
                    <br><br>
                    Thank you for choosing Nubyira.
                </div>"""
    subject = f"{subject}"

    email_content = ""
    try:
        zeptomail(email,"participant", subject, html_message)
        send_mail(
            subject,
            email_content,
            "admin@nubyira.com",
            [email],
            fail_silently=False,
            html_message=html_message,
        )

        return "email sent successfully"
    except BadHeaderError:
        pass
