from django.db import models
from django_resized import ResizedImageField
from django.db.models.signals import pre_save, post_save
from django.dispatch import receiver
from .course_cid import course_cid, generate_cid
from django.conf import settings
from django.utils import timezone
from moviepy.editor import VideoFileClip
import uuid
# Courses to be offered by the users most be future courses
from django.core.cache import cache

from django.db.models import QuerySet, Manager
from django_lifecycle import LifecycleModel, hook, AFTER_DELETE, AFTER_SAVE
from django.core.validators import FileExtensionValidator


class CustomQuerySet(QuerySet):
    def update(self, **kwargs):
        cache.delete("allCoursesList")
        cache.delete("webinarCourses")
        cache.delete("FreeCourses")
        cache.delete("PremiumCourses")
        cache.delete("course_schedule")
        # super(CustomQuerySet, self).update(
        #     last_updated=timezone.now, **kwargs)


class CustomManager(Manager):
    def get_queryset(self):
        return CustomQuerySet(self.model, using=self._db)


class VideoType(models.TextChoices):
    FREE = "Free", "Free"
    WEBINER = "Webinar", "Webinar"
    PREMIUM = "Premium", "Premium"

class FilterCategory(models.Model):
    name = models.CharField(max_length=200)

    def __str__(self):
        return self.name

class Filter(models.Model):
    category = models.ForeignKey(FilterCategory, on_delete=models.CASCADE, blank = True, null=True)
    label = models.CharField(max_length=200, help_text="This is the name of the filter e.g category or field or tarining software")
    value = models.CharField(max_length=200, help_text="This is the value of the filter e.g Basic")
    on = models.BooleanField(default=False, help_text="This is to make it available to the front end or not")

    def __str__(self):
        return f"{self.label}"


class Sort(models.Model):
    label = models.CharField(max_length=200, help_text="This is the name of the sort e.g name or date")
    value = models.CharField(max_length=200, help_text="this is the sort value e.g a-z or z-a or newest-first or oldest-first")
    on = models.BooleanField(default=False, help_text="This is to make it available to the front end or not")

    def __str__(self) -> str:
        
        return f"{self.label} : {self.value}"

values = "title, price, created_date, last_updated, duration"

class Courses(models.Model):
    category_option = (
        # (" ", " "),
        ("Basic Course", "Basic Course"),
        ("Intermediate Course", "Intermediate Course"),
        ("Professional Course", "Professional Course"),
    )

    title = models.CharField(max_length=300)
    course_tab = models.CharField(
        max_length=20, choices=VideoType.choices, default=VideoType.WEBINER
    )
    field = models.ForeignKey(Filter, on_delete=models.SET_NULL, null = True, blank = True)
    course_code = models.CharField(
        max_length=10, unique=True, blank=True, null=True)
    audience = models.ManyToManyField("course_audience", blank=True)
    prerequisite = models.ManyToManyField("course_prerequesites", blank=True)
    image = ResizedImageField(
        size=[3000, 1740], upload_to="course_pics", force_format="PNG", blank=True
    )
    thubmnail = models.ImageField(
        upload_to="premium_thumnail", blank=True, null=True)
    sm_thubmnail = models.ImageField(
        upload_to="premium_thumnail", blank=True, null=True)
    duration = models.PositiveIntegerField(
        help_text="This is the number of hours per day for the course", blank=True, null=True
    )
    course_objective = models.ManyToManyField("objectives", blank=True)
    overview = models.TextField(blank=True)
    course_start_date = models.DateField(blank=True, null=True)
    course_end_date = models.DateField(blank=True, null=True)
    number_of_days = models.PositiveIntegerField(blank=True, null=True)
    price = models.PositiveIntegerField(blank=True, null=True)
    venue = models.CharField(max_length=200, blank=True)
    category = models.CharField(
        choices=category_option, max_length=250, blank=True)
    active_course = models.BooleanField(default=False)
    reg_end_date = models.DateTimeField(blank=True, null=True)
    rating_star = models.FloatField(default=0)
    rating_number = models.IntegerField(default=0)
    video_link = models.TextField(blank=True)
    cid = models.CharField(max_length=200, blank=True)
    training_software = models.CharField(
        max_length=200, default="None", blank=True, verbose_name="Training software"
    )
    meta_tag = models.TextField(blank=True)
    files = models.FileField(upload_to="course_files", blank=True, null=True, validators=[FileExtensionValidator(allowed_extensions=["pdf", "zip"])])
    time = models.CharField(max_length=30, default="01:00 - 03:00")
    coupon_code = models.CharField(max_length=200, blank=True)
    last_updated = models.DateTimeField(default=timezone.now)
    date_created = models.DateTimeField(default=timezone.now)
    objects = CustomManager()

    class Meta:
        verbose_name_plural = "Courses"
        # ordering = ['category', "last_updated"]

    def __str__(self):
        return f"{self.title}"

    def save(self, *args, **kwargs):
        self.last_updated = timezone.now()
        super(Courses, self).save(*args, **kwargs)

    @hook(AFTER_SAVE)
    @hook(AFTER_DELETE)
    def invalidate_cache(self):
        cache.delete("allCoursesList")
        cache.delete("course_schedule")
        cache.delete("webinarCourses")
        cache.delete("FreeCourses")
        cache.delete("PremiumCourses")


class Video(models.Model):
    course = models.OneToOneField(
        Courses, on_delete=models.SET_NULL, null=True, blank=True)
    video_file = models.FileField(
        upload_to="course videos", blank=True
    )
    video_link = models.URLField(blank=True)
    duration = models.CharField(max_length=10, blank=True)

    def __str__(self):
        return f"Video file for {self.course}"


class course_audience(models.Model):
    course = models.ForeignKey(
        Courses, on_delete=models.CASCADE, null=True, blank=True)
    audience = models.CharField(max_length=300, blank=True, null=True)

    def __str__(self):
        return self.audience


class course_prerequesites(models.Model):
    course = models.ForeignKey(
        Courses, on_delete=models.CASCADE, null=True, blank=True)
    prerequesite = models.CharField(max_length=300, blank=True, null=True)

    def __str__(self):
        return self.prerequesite
        
    class Meta:
        verbose_name_plural = "Course Prerequesites" 


class objectives(models.Model):
    course = models.ForeignKey(
        Courses, on_delete=models.CASCADE, null=True, blank=True)
    objective = models.CharField(max_length=600, blank=True, null=True)

    def __str__(self):
        return self.objective
        
    class Meta:
        verbose_name_plural = "Course Objectvies" 



@receiver(post_save, sender=Courses)
def update_cid(sender, instance=None, created=False, **kwargs):
    if created:
        instance.cid = uuid.uuid4().hex
        instance.save()


@receiver(post_save, sender=Video)
def get_video_duration(sender, instance, created, **kwrgs):
    if created:
        course = instance.course
        if course.course_tab == "premium":
            video_link = instance.video_link
            course.video_link = video_link
        else:
            pass
        course.save()


# @receiver(post_save, sender=Courses)
# def update_last_updated(sender, instance, created, **kwargs):
#     course_to_update = Courses.objects.filter(pk=instance.pk)
#     course_to_update.update(last_updated=timezone.now)
