import collections
import uuid

def course_cid(course):
    if course.category == "Basic Course":
        return f"{course.course_abb}-basic"
    if course.category == "Intermediate Course":
        return f"{course.course_abb}-inter"
    else:
        return f"{course.course_abb}-prof"


"""Generate cid in the format of fc-abc: where abc is the combination of the first letters of the first three longest word in the title"""


def generate_cid(course):
    # get course type
    course_tab = course.course_tab

    # abbr the course tab name
    course_tab_abbr = course_tab[0].lower() + "c"

    # split the course title: this will return a list
    course_title_split = course.title.split() #[]
    title_length = [len(word) for word in course_title_split]
    titles = []
   
    for i in range(len(course_title_split)):
        max_value = max(title_length)
        titles.append(course_title_split[title_length.index(max_value)])
        course_title_split.remove(course_title_split[title_length.index(max_value)])
        title_length.remove(max_value)
        if len(titles) == 3:
            break
        
    
    course_abb = "".join([i[0].lower() for i in titles])
    
    course_cid = f"{course_tab_abbr}-{course_abb}"

    return course_cid
