from .models import course_batch, extra_participant
from .email import course_email


def get_sub_number(course_object):
    course_batch_no = course_object.batch_no
    # Get the sub num for the current course for the reg_obj
    gotten_sub_num = course_batch.objects.filter(
        course=course_object.course, active=True).first()
    gotten_sub_num.submission_number += 1
    gotten_sub_num.save()
    if len(str(gotten_sub_num)) == 1:
        sub_num = "00" + str(gotten_sub_num.submission_number)
    elif len(str(gotten_sub_num)) == 2:
        sub_num = "0" + str(gotten_sub_num.submission_number)
    else:
        sub_num = gotten_sub_num.submission_number
    return course_batch_no, sub_num


def get_reg_id(course_object):
    # get course name short code
    course_registered_for = course_object.course.title
    course_code = course_registered_for.course_code
    # Get the course category short code
    # course_cat_code = "".join(
    #     [entry[0] for entry in course_object.course.category.split(" ")])

    # Get other extra participants
    # other_participants = extra_participant.objects.filter(
    #     registra=course_object)
    number_of_slot = course_object.number_of_slots
    if number_of_slot > 1:
        course_batch_no, sub_num = get_sub_number(course_object)
        reg_id = course_code + \
            course_batch_no + sub_num + "." + str(number_of_slot - 1)

    else:
        course_batch_no, sub_num = get_sub_number(course_object)
        reg_id = course_code + course_batch_no + sub_num
    course_object.registration_id = reg_id
    course_object.save()

    # Send user(s) email containing the info about the webinar and user's generated id
    send_course_details = course_email(course_object, reg_id)
    return reg_id
