import phonenumbers
from phonenumbers import carrier
from rest_framework import serializers


def number_check(number):
    try:
        # Remove all spaces in the number
        if " " in number:
            number = number.replace(" ", "")
        number = phonenumbers.parse(str(number), None)
        if phonenumbers.is_valid_number(number):
            network = carrier.name_for_number(number, "en")
            return number
        else:
            if phonenumbers.is_possible_number(number):
                try:
                    network = carrier.name_for_number(number, "en")
                    if network == "":
                        raise serializers.ValidationError(
                            {"phone_number": "Number does not exist"})
                    else:
                        return number
                except (AttributeError, phonenumbers.NumberParseException):
                    raise serializers.ValidationError(
                        {"phone_number": "Coutry code missing"})
            else:
                raise serializers.ValidationError(
                    {"phone_number": "Number does not exist"})
    except (AttributeError, phonenumbers.NumberParseException):
        raise serializers.ValidationError(
            {"phone_number": "coutry code missing or incorrect"})
