from django.contrib.auth.decorators import login_required
from django.shortcuts import render, redirect
from django.contrib import messages
from django.db import transaction
from .models import *
from .forms import *
from .email import *
from .course_models import *


@login_required()
def adminView(request):
    if not request.user.is_staff:
        return redirect("https://nubyira.com")
    context = {}

    return render(request, "admin_dash/admin_index.html", context)


@transaction.atomic
def admin_blogs(request):
    the_blogs = blogs.objects.order_by("-views")
    authors = Author.objects.all()
    context = {"the_blogs": the_blogs, "authors": authors}
    if request.method == "POST":
        form = BlogForm(request.POST)
        if form.is_valid():
            form.save()
            messages.success(request, "Blog added successfully")
        else:
            context['form'] = form

    return render(request, 'admin_dash/blogs.html', context)


@transaction.atomic
def edit_blogs(request, blog_id):
    # get the blog ast the instance to update
    the_blog = blogs.objects.get(id=blog_id)
    # get all authors
    authors = Author.objects.all()
    image = request.FILES.get("image")
    context = {"the_blog": the_blog, "authors": authors}
    if image:
        # delete previous image
        if the_blog.image:
            the_blog.image.delete()
    if request.method == "POST":
        # attach the form to the instance for update
        form = BlogForm(request.POST, instance=the_blog)
        # get the image if provided
        if form.is_valid():
            # save the form
            new_form = form.save()
            if image:
                the_blog.image = image
                the_blog.save()
            messages.success(request, "Blog updated successfully")
            return redirect("admin_blogs")
        else:
            context['form'] = form

    return render(request, 'admin_dash/editblog.html', context)


@transaction.atomic
def edit_course(request, course_id):
    # get the blog ast the instance to update
    the_course = Courses.objects.filter(
        id=course_id).prefetch_related("audience", "course_objectives", "prerequisites")

    if the_course.first().course_tab == "Webinar":
        state = "webinar"
        image = request.FILES.get("image")
        if image and the_course.first().image:
            the_course.first().image.delete()
    elif the_course.first().course_tab == "Free":
        state = "free"
    else:
        state = "premium"
    files = request.FILES.get("files")
    thubmnail = request.FILES.get("thubmnail")
    sm_thubmnail = request.FILES.get("sm_thubmnail")
    if files and the_course.first().files:
        the_course.first().files.delete()
    if thubmnail and the_course.first().thubmnail:
        the_course.first().thubmnail.delete()
    if sm_thubmnail and the_course.first().sm_thubmnail:
        the_course.first().thubmnail.delete()
    context = {"the_course": the_course, "state": state}
    if request.method == "POST" and state == "webinar":
        # attach the form to the instance for update
        form = WebCourseForm(request.POST, request.FILES,
                             instance=the_course.first())
        if form.is_valid():
            # save the form
            new_form = form.save()
            if image:
                the_course.first().image = image
                the_course.first().save()
            messages.success(request, "Course updated successfully")
            return redirect("admin_courses")
        else:
            context['form'] = form
    elif request.method == "POST" and (state == "free" or state == "premium"):
        form = FreeCourseForm(request.POST, request.FILES,
                              instance=the_course.first())
        if form.is_valid():
            new_form = form.save()
            if files:
                the_course.first().files = files
            if sm_thubmnail:
                the_course.first().sm_thubmnail = sm_thubmnail
            if thubmnail:
                the_course.first().thubmnail = thubmnail
            the_course.first().save()
            messages.success(request, "Course updated successfully")
            return redirect("admin_courses")
        else:
            context['form'] = form

    return render(request, 'admin_dash/edit_webcourse.html', context)


def admin_course__user_registered(request):
    reg_users = course_registred_user.objects.all()
    webCourses = Courses.objects.filter(course_tab="Webinar")
    context = {"reg_users": reg_users, "webCourses": webCourses}
    return render(request, "admin_dash/course_reg.html", context)


@login_required()
def delete_blog(request, blog_id):
    the_blog = blogs.objects.get(id=blog_id)
    the_blog.delete()
    messages.success(request, "Blog deleted successfully")
    return redirect("admin_blogs")


@login_required()
def delete_course(request, course_id):
    the_course = blogs.objects.get(id=course_id)
    the_course.delete()
    messages.success(request, "course deleted successfully")
    return redirect("admin_courses")


@login_required()
@transaction.atomic
def sub_user(request, user_id, status):
    if not request.user.is_staff:
        return redirect("https://nubyira.com")
    user = User.objects.get(pk=user_id)
    user_sub, created = Subscription.objects.get_or_create(user=user)
    if status == 'revoke':
        user_sub.subscribed = False
        messages.success(request, "Subscription removed successfully")
    elif status == "grant":
        user_sub.subscribed = True
        messages.success(request, "Subscription enabled successfully")
    user_sub.save()
    return redirect("all_users")


@login_required()
def admin_payment(request):
    payments = payment.objects.filter(status="Completed").order_by("-date")
    sub = Subscription.objects.filter(subscribed=True)
    context = {"payments": payments, "sub": sub}
    return render(request, "admin_dash/payments.html", context)


def add_audience_preq_obj(obj, new_form, field):
    obj_list = obj.split(",")
    for obj in obj_list:
        if field == "audience":
            aud_ins = course_audience.objects.filter(audience=obj.strip())
            if aud_ins.exists():
                new_form.audience.add(aud_ins.first())
            else:
                new_aud = course_audience.objects.create(
                    course=new_form, audience=obj.strip())
                new_form.audience.add(new_aud)
        elif field == "prerequisites":
            preq_ins = course_prerequesites.objects.filter(
                prerequesite=obj.strip())
            if preq_ins.exists():
                new_form.prerequisites.add(preq_ins.first())
            else:
                new_preq = course_prerequesites.objects.create(
                    course=new_form, prerequesite=obj.strip())
                new_form.prerequisites.add(new_preq)
        elif field == "course_objectives":
            obj_ins = objectives.objects.filter(objective=obj.strip())
            if obj_ins.exists():
                new_form.course_objectives.add(obj_ins.first())
            else:
                new_obj = objectives.objects.create(
                    course=new_form, objective=obj.strip())
                new_form.course_objectives.add(new_obj)
        new_form.save()


@login_required()
def admin_course(request):
    courses = Courses.objects.order_by("-last_updated")
    context = {"courses": courses}
    if request.method == "POST" and request.GET.get("form") == "webinar":
        form = WebCourseForm(request.POST, request.FILES)
        if form.is_valid():
            new_form = form.save()
            the_audience = request.POST.get("audience")
            the_prerequisites = request.POST.get("prerequisites")
            the_course_objectives = request.POST.get("course_objectives")
            if the_audience:
                add_audience_preq_obj(the_audience, new_form, "audience")
            if the_prerequisites:
                add_audience_preq_obj(
                    the_prerequisites, new_form, "prerequisites")
            if the_course_objectives:
                add_audience_preq_obj(
                    the_course_objectives, new_form, "course_objectives")
            messages.success(request, "course saved successfully")
        else:
            context['form'] = form
    elif request.method == "POST":
        form = FreeCourseForm(request.POST, request.FILES)
        if form.is_valid():
            new_form = form.save()
            if request.GET.get("form") == 'premium':
                new_form.sm_thubmnail = request.FILES.get("sm_thubmnail")
                new_form.thubmnail = request.FILES.get("thubmnail")
                new_form.save()
            vid_dur = Video.objects.create(
                course=new_form, duration=request.POST.get("vid_duration"))
            messages.success(request, "course added successfully")
        else:
            context['form'] = form
    return render(request, "admin_dash/course.html", context)


@ login_required()
def all_users(request):
    if not request.user.is_staff:
        return redirect("https://nubyira.com")
    all_users = User.objects.order_by("-is_staff")
    context = {"all_users": all_users}
    return render(request, "admin_dash/users.html", context)


@ login_required()
def access(request, user_id, action):
    if not request.user.is_staff:
        return redirect("https://nubyira.com")
    user = User.objects.get(id=user_id)
    if action == "grant":
        user.is_staff = True
        user.save()
        messages.success(request, "Access granted successfully")
    else:
        user.is_staff = False
        user.save()
        messages.success(request, "Access revert successfully")

    return redirect("admin_page")


@ login_required()
def admin_send_user_email(request):
    if request.method == "POST":
        if not request.user.is_staff:
            return redirect("https://nubyira.com")
        email = request.POST.get("email")
        message = request.POST.get("message")
        subject = request.POST.get("subject")
        if User.objects.filter(email=email).exists():
            email_user(email, subject, message)
            messages.success(request, "Message sent successfully")

        return redirect("admin_page")


def projects(request):
    executed_projects = project.objects.filter(executed=True).order_by("-pk")
    sub_projects = project_submission.objects.select_related("user")
    context = {"projects": executed_projects, "sub_projects": sub_projects}
    if request.method == "POST":
        form = projectForm(request.POST, request.FILES)
        if form.is_valid():
            form.save()
            messages.success(request, "Project added successfully")
    return render(request, "admin_dash/projects.html", context)


@transaction.atomic
def edit_projects(request, project_id):
    # get the project ast the instance to update
    the_project = project.objects.get(id=project_id)
    image = request.FILES.get("image")
    detail_image = request.FILES.get("detail_image")
    context = {"the_project": the_project}
    if image and the_project.image:
        the_project.image.delete()
    if detail_image and the_project.detail_image:
        the_project.detail_image.delete()
    if request.method == "POST":
        # attach the form to the instance for update
        form = projectForm(request.POST, instance=the_project)
        # get the image if provided
        if form.is_valid():
            # save the form
            new_form = form.save()
            if image:
                the_project.image = image
                the_project.save()
            if detail_image:
                the_project.detail_image = detail_image
                the_project.save()
            messages.success(request, "Project updated successfully")
            return redirect("projects")
        else:
            context['form'] = form

    return render(request, 'admin_dash/editproject.html', context)
