from django.contrib import admin
from django.db.models import fields
from .models import (
    User,
    review,
    course_registred_user,
    paypal_access,
    course_registered_user_proxy,
    project,
    project_batch,
    payment,
    course_batch,
    blogs,
    IpModel,
    course_certificate,
    comment,
    passwordresetcode,
    extra_participant,
    emailconfirmationcode,
    Project_files,
    saved_blogs,
    Subscription,
    project_submission,
    Author,
    Ads
)

from .course_models import (
    Courses,
    course_audience,
    course_prerequesites,
    objectives,
    Video,Filter,Sort,FilterCategory
)
from .forms import CertificateForm


from .forms import CourseForm

class COurseAdmin(admin.ModelAdmin):
    # raw_id_fields = ['user']
    # list_display = ["title", "publish_date"]
    form = CourseForm

class passwordresetcodeAdmin(admin.ModelAdmin):
    list_display = ["code", "created_at", "user"]


class PaymentAdmin(admin.ModelAdmin):
    list_filter = ["status"]


class Extra_participantInline(admin.TabularInline):
    model = extra_participant
    extra = 0


class objectivesInline(admin.TabularInline):
    model = objectives
    extra = 0


class course_audienceInline(admin.TabularInline):
    model = course_audience
    extra = 0


class course_prerequesitesInline(admin.TabularInline):
    model = course_prerequesites
    extra = 0


class course_registred_userAdmin(admin.ModelAdmin):
    inlines = [
        Extra_participantInline,
    ]

    list_display = ["first_name", "last_name", "course", "batch_no"]
    list_filter = ["batch_no", "course"]
    fieldsets = (
        (
            "Primary Information",
            {
                "fields": (
                    ("user", "email"),
                    ("first_name", "last_name", "middle_name"),
                    ("phone_number", "professional_academic_field"),
                    ("zip_number", "address", "country"),
                )
            },
        ),
        (
            "Course Information",
            {
                "fields": (
                    ("course", "registration_id"),
                    ("attendance", "batch_no"),
                    ("number_of_slots", "paid", "pay_later"),
                    ("reference_id", "payment_reference_id"),
                    ("start_date", "end_date", "date_registered"),
                    ("completed", "postponed", "archived", "certificate"),
                )
            },
        ),
    )


class course_audienceInlineAdmin(admin.ModelAdmin):
    inlines = [course_audienceInline,
               course_prerequesitesInline, objectivesInline]
    list_display = ["title", "category", "active_course", "course_tab"]
    # form = CourseForm
    fieldsets = (
        (
            "General Details",
            {
                "fields": (
                    ("title", "course_tab"),
                    ("course_code", "image",),
                    "last_updated","field",
                    "overview",
                    "meta_tag",
                    ("training_software", "category"),
                    ("cid", "files"),
                    "video_link",
                    ("rating_number", "rating_star", "active_course"),
                )
            },
        ),
        (
            "Webinar Courses",
            {
                "fields": (
                    # (
                    #     "audience",
                    # ),
                    # "prerequisites",
                    ("thubmnail", "duration"),
                    ("number_of_days", "venue"),
                    ("price", "sm_thubmnail"),
                    # ("course_objectives",),
                    ("reg_end_date", "time",),
                    ("course_start_date",
                        "course_end_date",
                     ),
                )
            },
        ),
        # ("Free and Premium Courses", {"fields": ("videos",)}),
    )


class userAdmin(admin.ModelAdmin):
    list_display = ["email", "first_name", "last_name", "is_verified"]
    list_filter = ["is_verified"]
    search_fields = ["email", "date_joined"]


class subAdmin(admin.ModelAdmin):
    list_display = ["user", "subscribed"]
    list_filter = ["subscribed"]
    search_fields = ["user"]


@admin.register(course_certificate)
class certificateAdmin(admin.ModelAdmin):
    form = CertificateForm

admin.site.register(FilterCategory)
admin.site.register(Filter)
admin.site.register(Sort)
admin.site.register(User, userAdmin)
admin.site.register(Courses, course_audienceInlineAdmin)
admin.site.register(course_audience)
admin.site.register(course_prerequesites)
admin.site.register(objectives)
admin.site.register(review)
admin.site.register(course_registred_user, course_registred_userAdmin)
admin.site.register(project)
admin.site.register(project_submission)
admin.site.register(project_batch)
admin.site.register(payment, PaymentAdmin)
admin.site.register(course_batch)
admin.site.register(blogs)
admin.site.register(IpModel)
admin.site.register(comment)
admin.site.register(saved_blogs)
admin.site.register(Subscription, subAdmin)
admin.site.register(passwordresetcode, passwordresetcodeAdmin)
admin.site.register(emailconfirmationcode, passwordresetcodeAdmin)
admin.site.register(Author)
admin.site.register(paypal_access)
admin.site.register(Project_files)
admin.site.register(extra_participant)
admin.site.register(course_registered_user_proxy, course_registred_userAdmin)
admin.site.register(Video)
admin.site.register(Ads)
